/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.restoretools.iterative.psf;

import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix3D;
import edu.emory.mathcs.restoretools.iterative.FloatCommon3D;
import ij.ImagePlus;
import ij.ImageStack;

public class FloatPSF3D {
    private FloatMatrix3D[][][] image;
    private int[][][][] center;

    public FloatPSF3D(ImagePlus[][][] imPSF) {
        this.image = new FloatMatrix3D[imPSF.length][imPSF[0].length][imPSF[0][0].length];
        this.center = new int[imPSF.length][imPSF[0].length][imPSF[0][0].length][3];
        for (int i = 0; i < imPSF.length; ++i) {
            for (int j = 0; j < imPSF[0].length; ++j) {
                for (int k = 0; k < imPSF[0][0].length; ++k) {
                    ImageStack isPSF = imPSF[i][j][k].getStack();
                    this.image[i][j][k] = new DenseFloatMatrix3D(isPSF.getSize(), isPSF.getHeight(), isPSF.getWidth());
                    FloatCommon3D.assignPixelsToMatrix(isPSF, this.image[i][j][k]);
                    float[] tmp = this.image[i][j][k].getMaxLocation();
                    this.center[i][j][k][0] = (int)tmp[1];
                    this.center[i][j][k][1] = (int)tmp[2];
                    this.center[i][j][k][2] = (int)tmp[3];
                }
            }
        }
    }

    public int[][][][] getCenter() {
        return this.center;
    }

    public FloatMatrix3D[][][] getImage() {
        return this.image;
    }

    public int getNumberOfImages() {
        return this.image.length;
    }

    public int[] getSize() {
        int[] size = new int[3];
        if (this.image.length > 1 || this.image[0].length > 1 || this.image[0][0].length > 1) {
            int maxSliceSize = this.image[0][0][0].slices();
            int maxRowSize = this.image[0][0][0].rows();
            int maxColSize = this.image[0][0][0].columns();
            for (int i = 0; i < this.image.length; ++i) {
                for (int j = 0; j < this.image[0].length; ++j) {
                    for (int k = 0; k < this.image[0][0].length; ++k) {
                        if (this.image[i][j][k].slices() > maxSliceSize) {
                            maxSliceSize = this.image[i][j][k].slices();
                        }
                        if (this.image[i][j][k].rows() > maxRowSize) {
                            maxRowSize = this.image[i][j][k].rows();
                        }
                        if (this.image[i][j][k].columns() <= maxColSize) continue;
                        maxColSize = this.image[i][j][k].columns();
                    }
                }
            }
            size[0] = maxSliceSize;
            size[1] = maxRowSize;
            size[2] = maxColSize;
        } else {
            size[0] = this.image[0][0][0].slices();
            size[1] = this.image[0][0][0].rows();
            size[2] = this.image[0][0][0].columns();
        }
        return size;
    }
}

