/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.https.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tigerbrokers.stock.openapi.client.TigerApiException;
import com.tigerbrokers.stock.openapi.client.https.client.TigerClient;
import com.tigerbrokers.stock.openapi.client.https.request.TigerHttpRequest;
import com.tigerbrokers.stock.openapi.client.https.request.TigerRequest;
import com.tigerbrokers.stock.openapi.client.https.response.TigerHttpResponse;
import com.tigerbrokers.stock.openapi.client.https.response.TigerResponse;
import com.tigerbrokers.stock.openapi.client.struct.enums.TigerApiCode;
import com.tigerbrokers.stock.openapi.client.util.StringUtils;
import com.tigerbrokers.stock.openapi.client.util.TigerSignature;
import com.tigerbrokers.stock.openapi.client.util.WebUtils;
import java.net.SocketTimeoutException;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerHttpClient
implements TigerClient {
    private static final Logger logger = LoggerFactory.getLogger(TigerHttpClient.class);
    private String serverUrl;
    private String tigerId;
    private String privateKey;
    private String tigerPublicKey;
    private String signType = "RSA";
    private String charset = "UTF-8";
    private int connectTimeout = 10000;
    private int readTimeout = 15000;

    public TigerHttpClient(String serverUrl, String tigerId, String privateKey, String tigerPublicKey) {
        this.serverUrl = serverUrl;
        this.tigerId = tigerId;
        this.privateKey = privateKey;
        this.tigerPublicKey = tigerPublicKey;
    }

    @Override
    public <T extends TigerResponse> T execute(TigerRequest<T> request) {
        if (request instanceof TigerHttpRequest) {
            return (T)this.execute((TigerHttpRequest)request);
        }
        return null;
    }

    public TigerHttpResponse execute(TigerHttpRequest request) {
        TigerHttpResponse response;
        try {
            String data = this.doPost(request);
            if (StringUtils.isEmpty(data)) {
                return null;
            }
            response = (TigerHttpResponse)JSON.parseObject((String)data, TigerHttpResponse.class);
            if (StringUtils.isEmpty(this.tigerPublicKey)) {
                return response;
            }
            if (response.getSign() == null) {
                return response;
            }
            boolean signSuccess = TigerSignature.rsaCheckContent(request.getTimestamp(), response.getSign(), this.tigerPublicKey, this.charset);
            if (!signSuccess) {
                throw new TigerApiException(TigerApiCode.SIGN_CHECK_FAILED);
            }
        }
        catch (TigerApiException e) {
            logger.error("client execute api exeception:", (Throwable)e);
            return TigerHttpResponse.errorMsg(e.getApiError());
        }
        catch (Exception e) {
            logger.error("client execute exception:", (Throwable)e);
            return TigerHttpResponse.errorMsg(TigerApiCode.CLIENT_API_ERROR);
        }
        return response;
    }

    private String doPost(TigerHttpRequest request) throws TigerApiException {
        if (StringUtils.isEmpty(request.getApiMethodName())) {
            throw new TigerApiException(TigerApiCode.METHOD_NAME_ERROR);
        }
        try {
            return WebUtils.doPost(this.serverUrl, "application/json", JSONObject.toJSONString(this.buildParams(request)), this.connectTimeout, this.readTimeout);
        }
        catch (TigerApiException e) {
            logger.error("client post request tiger api exception:", (Throwable)e);
            throw new TigerApiException(e.getMessage());
        }
        catch (SocketTimeoutException e) {
            logger.error("client post request socket time out exception:", (Throwable)e);
            throw new TigerApiException(TigerApiCode.READ_TIME_OUT);
        }
        catch (Exception e) {
            logger.error("client post request exception:", (Throwable)e);
            throw new TigerApiException(e.getMessage());
        }
    }

    private Map<String, Object> buildParams(TigerHttpRequest request) throws TigerApiException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("method", request.getApiMethodName());
        params.put("version", request.getApiVersion());
        params.put("tiger_id", this.tigerId);
        params.put("sign_type", this.signType);
        params.put("charset", this.charset);
        params.put("timestamp", request.getTimestamp());
        params.put("biz_content", request.getBizContent());
        String signContent = TigerSignature.getSignContent(params);
        String sign = TigerSignature.rsaSign(signContent, this.privateKey, this.charset);
        params.put("sign", sign);
        return params;
    }

    static {
        Security.setProperty("jdk.certpath.disabledAlgorithms", "");
    }
}

