/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.util;

import com.tigerbrokers.stock.openapi.client.struct.enums.Subject;
import com.tigerbrokers.stock.openapi.client.util.builder.StompHeaderBuilder;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.stomp.DefaultStompFrame;
import io.netty.handler.codec.stomp.StompCommand;
import io.netty.handler.codec.stomp.StompFrame;
import io.netty.handler.codec.stomp.StompHeaders;
import java.nio.charset.Charset;
import java.util.Set;

public class StompMessageUtil {
    public static StompFrame buildConnectMessage(String login, String passcode, String version) {
        DefaultStompFrame stompFrame = new DefaultStompFrame(StompCommand.CONNECT);
        stompFrame.headers().set((Headers)StompHeaderBuilder.instance().version(version).host().login(login).passcode(passcode).build());
        return stompFrame;
    }

    public static StompFrame buildSendMessage(int reqType, String message) {
        if (reqType <= 0) {
            throw new RuntimeException("reqType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DefaultStompFrame stompFrame = message != null ? new DefaultStompFrame(StompCommand.SEND, Unpooled.wrappedBuffer((byte[])message.getBytes(Charset.defaultCharset()))) : new DefaultStompFrame(StompCommand.SEND);
        StompHeaders headers = StompHeaderBuilder.instance().version().host().reqType(reqType).build();
        stompFrame.headers().set((Headers)headers);
        return stompFrame;
    }

    public static StompFrame buildSubscribeMessage(Subject subject) {
        DefaultStompFrame stompFrame = new DefaultStompFrame(StompCommand.SUBSCRIBE);
        StompHeaders headers = StompHeaderBuilder.instance().version().host().subject(subject).build();
        stompFrame.headers().set((Headers)headers);
        return stompFrame;
    }

    public static StompFrame buildSubscribeMessage(Set<String> symbols) {
        DefaultStompFrame stompFrame = new DefaultStompFrame(StompCommand.SUBSCRIBE);
        StompHeaders headers = StompHeaderBuilder.instance().version().host().subject("Quote").symbols(symbols).build();
        stompFrame.headers().set((Headers)headers);
        return stompFrame;
    }

    public static StompFrame buildSubscribeMessage(Set<String> symbols, Set<String> focusKeys) {
        DefaultStompFrame stompFrame = new DefaultStompFrame(StompCommand.SUBSCRIBE);
        StompHeaders headers = StompHeaderBuilder.instance().version().host().subject("Quote").symbols(symbols).focusKeys(focusKeys).build();
        stompFrame.headers().set((Headers)headers);
        return stompFrame;
    }

    public static StompFrame buildSubscribeMessage(Subject subject, Set<String> focusKeys) {
        DefaultStompFrame stompFrame = new DefaultStompFrame(StompCommand.SUBSCRIBE);
        StompHeaders headers = StompHeaderBuilder.instance().version().host().subject(subject).focusKeys(focusKeys).build();
        stompFrame.headers().set((Headers)headers);
        return stompFrame;
    }

    public static StompFrame buildUnSubscribeMessage(Subject subject) {
        DefaultStompFrame stompFrame = new DefaultStompFrame(StompCommand.UNSUBSCRIBE);
        StompHeaders headers = StompHeaderBuilder.instance().version().host().subject(subject).build();
        stompFrame.headers().set((Headers)headers);
        return stompFrame;
    }

    public static StompFrame buildUnSubscribeMessage(Set<String> symbols) {
        DefaultStompFrame stompFrame = new DefaultStompFrame(StompCommand.UNSUBSCRIBE);
        StompHeaders headers = StompHeaderBuilder.instance().version().host().subject("Quote").symbols(symbols).build();
        stompFrame.headers().set((Headers)headers);
        return stompFrame;
    }
}

