/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.util;

import com.tigerbrokers.stock.openapi.client.TigerApiException;
import com.tigerbrokers.stock.openapi.client.struct.enums.TigerApiCode;
import com.tigerbrokers.stock.openapi.client.util.StreamUtil;
import com.tigerbrokers.stock.openapi.client.util.StringUtils;
import com.tigerbrokers.stock.openapi.client.util.codec.Base64;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class TigerSignature {
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;
    private static final String PRIVATE_KEY_BEGIN = "-----BEGIN PRIVATE KEY-----";
    private static final String PRIVATE_KEY_END = "-----END PRIVATE KEY-----";

    public static String getSignContent(Map<String, Object> request) {
        StringBuffer content = new StringBuffer();
        ArrayList<String> keys = new ArrayList<String>(request.keySet());
        Collections.sort(keys);
        int index = 0;
        for (int i = 0; i < keys.size(); ++i) {
            String key;
            Object value = request.get(key = (String)keys.get(i));
            String strValue = value instanceof String ? (String)value : value.toString();
            if (!StringUtils.areNotEmpty(key, strValue)) continue;
            content.append((index == 0 ? "" : "&") + key + "=" + value);
            ++index;
        }
        return content.toString();
    }

    public static String rsaSign(String content, String privateKey, String charset) throws TigerApiException {
        if (privateKey.contains(PRIVATE_KEY_BEGIN)) {
            privateKey = privateKey.replace(PRIVATE_KEY_BEGIN, "");
        }
        if (privateKey.contains(PRIVATE_KEY_END)) {
            privateKey = privateKey.replace(PRIVATE_KEY_END, "");
        }
        try {
            PrivateKey priKey = TigerSignature.getPrivateKey("RSA", new ByteArrayInputStream(privateKey.getBytes()));
            Signature signature = Signature.getInstance("SHA1WithRSA");
            signature.initSign(priKey);
            if (StringUtils.isEmpty(charset)) {
                signature.update(content.getBytes());
            } else {
                signature.update(content.getBytes(charset));
            }
            byte[] signed = signature.sign();
            return new String(Base64.encodeBase64(signed));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static PrivateKey getPrivateKey(String algorithm, InputStream ins) throws Exception {
        if (ins == null || StringUtils.isEmpty(algorithm)) {
            return null;
        }
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        byte[] encodedKey = StreamUtil.readText(ins).getBytes();
        encodedKey = Base64.decodeBase64(encodedKey);
        return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
    }

    public static boolean rsaCheckContent(String content, String sign, String publicKey, String charset) throws TigerApiException {
        boolean rsaCheckContent = TigerSignature.rsaCheck(content, sign, publicKey, charset);
        if (!rsaCheckContent && (content.contains("\\/") || content.contains("\\\""))) {
            String sourceData = content.replace("\\/", "/").replace("\\\"", "\"");
            boolean jsonCheck = TigerSignature.rsaCheck(sourceData, sign, publicKey, charset);
            return jsonCheck;
        }
        return rsaCheckContent;
    }

    private static boolean rsaCheck(String content, String sign, String publicKey, String charset) throws TigerApiException {
        try {
            PublicKey pubKey = TigerSignature.getPublicKey("RSA", new ByteArrayInputStream(publicKey.getBytes()));
            Signature signature = Signature.getInstance("SHA1WithRSA");
            signature.initVerify(pubKey);
            if (StringUtils.isEmpty(charset)) {
                signature.update(content.getBytes());
            } else {
                signature.update(content.getBytes(charset));
            }
            return signature.verify(Base64.decodeBase64(sign.getBytes()));
        }
        catch (Exception e) {
            throw new TigerApiException(TigerApiCode.SIGN_CHECK_FAILED);
        }
    }

    public static PublicKey getPublicKey(String algorithm, InputStream ins) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        StringWriter writer = new StringWriter();
        StreamUtil.io(new InputStreamReader(ins), writer);
        byte[] encodedKey = writer.toString().getBytes();
        encodedKey = Base64.decodeBase64(encodedKey);
        return keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
    }
}

