/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.https.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tigerbrokers.stock.openapi.client.TigerApiException;
import com.tigerbrokers.stock.openapi.client.https.client.TigerClient;
import com.tigerbrokers.stock.openapi.client.https.domain.ApiModel;
import com.tigerbrokers.stock.openapi.client.https.domain.BatchApiModel;
import com.tigerbrokers.stock.openapi.client.https.request.TigerHttpRequest;
import com.tigerbrokers.stock.openapi.client.https.request.TigerRequest;
import com.tigerbrokers.stock.openapi.client.https.response.TigerResponse;
import com.tigerbrokers.stock.openapi.client.struct.enums.AccountType;
import com.tigerbrokers.stock.openapi.client.struct.enums.TigerApiCode;
import com.tigerbrokers.stock.openapi.client.util.ApiLogger;
import com.tigerbrokers.stock.openapi.client.util.HttpUtils;
import com.tigerbrokers.stock.openapi.client.util.StringUtils;
import com.tigerbrokers.stock.openapi.client.util.TigerSignature;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;

public class TigerHttpClient
implements TigerClient {
    private String serverUrl;
    private String tigerId;
    private String privateKey;
    private String tigerPublicKey;
    private String accessToken;
    private String tradeToken;
    private String accountType;
    private static final String ONLINE_PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDNF3G8SoEcCZh2rshUbayDgLLrj6rKgzNMxDL2HSnKcB0+GPOsndqSv+a4IBu9+I3fyBp5hkyMMG2+AXugd9pMpy6VxJxlNjhX1MYbNTZJUT4nudki4uh+LMOkIBHOceGNXjgB+cXqmlUnjlqha/HgboeHSnSgpM3dKSJQlIOsDwIDAQAB";
    private static final String SANDBOX_PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCbm21i11hgAENGd3/f280PSe4g9YGkS3TEXBYMidihTvHHf+tJ0PYD0o3PruI0hl3qhEjHTAxb75T5YD3SGK4IBhHn/Rk6mhqlGgI+bBrBVYaXixmHfRo75RpUUuWACyeqQkZckgR0McxuW9xRMIa2cXZOoL1E4SL4lXKGhKoWbwIDAQAB";
    private String signType = "RSA";
    private String charset = "UTF-8";

    public TigerHttpClient(String serverUrl, String tigerId, String privateKey) {
        if (serverUrl == null) {
            throw new RuntimeException("serverUrl is empty.");
        }
        if (tigerId == null) {
            throw new RuntimeException("tigerId is empty.");
        }
        if (privateKey == null) {
            throw new RuntimeException("privateKey is empty.");
        }
        this.serverUrl = serverUrl;
        this.tigerId = tigerId;
        this.privateKey = privateKey;
        this.tigerPublicKey = serverUrl.contains("openapi-internal.itradeup.com") ? ONLINE_PUBLIC_KEY : SANDBOX_PUBLIC_KEY;
    }

    public TigerHttpClient(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public TigerHttpClient(String serverUrl, String accessToken) {
        this.serverUrl = serverUrl;
        this.accessToken = accessToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setTradeToken(String tradeToken) {
        this.tradeToken = tradeToken;
    }

    public String getTradeToken() {
        return this.tradeToken;
    }

    public void setAccountType(AccountType accountType) {
        if (accountType != null) {
            this.accountType = accountType.name();
        }
    }

    public String getAccountType() {
        return this.accountType;
    }

    @Override
    public <T extends TigerResponse> T execute(TigerRequest<T> request) {
        String param = null;
        String data = null;
        try {
            param = JSONObject.toJSONString(this.buildParams(request));
            ApiLogger.debug("request param:{}", param);
            data = HttpUtils.post(this.serverUrl, param);
            if (StringUtils.isEmpty(data)) {
                return null;
            }
            TigerResponse response = (TigerResponse)JSON.parseObject((String)data, request.getResponseClass());
            if (StringUtils.isEmpty(this.tigerPublicKey) || response.getSign() == null) {
                return (T)response;
            }
            boolean signSuccess = TigerSignature.rsaCheckContent(request.getTimestamp(), response.getSign(), this.tigerPublicKey, this.charset);
            if (!signSuccess) {
                throw new TigerApiException(TigerApiCode.SIGN_CHECK_FAILED);
            }
            return (T)response;
        }
        catch (RuntimeException e) {
            ApiLogger.error(this.tigerId, request.getApiMethodName(), request.getApiVersion(), param, data, e);
            return this.errorResponse(this.tigerId, request, e);
        }
        catch (TigerApiException e) {
            ApiLogger.error(this.tigerId, request.getApiMethodName(), request.getApiVersion(), param, data, e);
            return this.errorResponse(this.tigerId, request, e);
        }
        catch (Exception e) {
            ApiLogger.error(this.tigerId, request.getApiMethodName(), request.getApiVersion(), param, data, e);
            return this.errorResponse(this.tigerId, request, e);
        }
    }

    private <T extends TigerResponse> T errorResponse(String tigerId, TigerRequest<T> request, TigerApiException e) {
        try {
            ApiLogger.error(tigerId, request.getApiMethodName(), request.getApiVersion(), e);
            TigerResponse response = (TigerResponse)request.getResponseClass().newInstance();
            response.setCode(e.getErrCode());
            response.setMessage(e.getErrMsg());
            return (T)response;
        }
        catch (Exception e1) {
            ApiLogger.error(tigerId, request.getApiMethodName(), request.getApiVersion(), e1);
            return null;
        }
    }

    private <T extends TigerResponse> T errorResponse(String tigerId, TigerRequest<T> request, Exception e) {
        try {
            ApiLogger.error(tigerId, request.getApiMethodName(), request.getApiVersion(), e);
            TigerResponse response = (TigerResponse)request.getResponseClass().newInstance();
            response.setCode(TigerApiCode.CLIENT_API_ERROR.getCode());
            response.setMessage(TigerApiCode.CLIENT_API_ERROR.getMessage() + "(" + e.getMessage() + ")");
            return (T)response;
        }
        catch (Exception e1) {
            ApiLogger.error(tigerId, request.getApiMethodName(), request.getApiVersion(), e1);
            return null;
        }
    }

    private Map<String, Object> buildParams(TigerRequest request) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("method", request.getApiMethodName());
        params.put("version", request.getApiVersion());
        if (request instanceof TigerHttpRequest) {
            params.put("biz_content", ((TigerHttpRequest)request).getBizContent());
        } else {
            ApiModel apiModel = request.getApiModel();
            if (apiModel instanceof BatchApiModel) {
                params.put("biz_content", JSONObject.toJSONString(((BatchApiModel)apiModel).getItems()));
            } else {
                params.put("biz_content", JSONObject.toJSONString((Object)apiModel));
            }
        }
        params.put("timestamp", request.getTimestamp());
        params.put("charset", this.charset);
        params.put("tiger_id", this.tigerId);
        params.put("sign_type", this.signType);
        if (this.accessToken != null) {
            params.put("access_token", this.accessToken);
        }
        if (this.tradeToken != null) {
            params.put("trade_token", this.tradeToken);
        }
        if (this.accountType != null) {
            params.put("account_type", this.accountType);
        }
        if (this.tigerId != null) {
            String signContent = TigerSignature.getSignContent(params);
            String sign = TigerSignature.rsaSign(signContent, this.privateKey, this.charset);
            params.put("sign", sign);
        }
        return params;
    }

    static {
        Security.setProperty("jdk.certpath.disabledAlgorithms", "");
    }
}

