/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.socket;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tigerbrokers.stock.openapi.client.socket.ApiComposeCallback;
import com.tigerbrokers.stock.openapi.client.socket.OrderIdPassport;
import com.tigerbrokers.stock.openapi.client.struct.SubscribedSymbol;
import io.netty.handler.codec.stomp.StompFrame;
import java.nio.charset.Charset;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiCallbackDecoder {
    private static Logger logger = LoggerFactory.getLogger(ApiCallbackDecoder.class);
    private ApiComposeCallback callback;
    private StompFrame stompFrame;
    private CyclicBarrier cyclicBarrier;
    private OrderIdPassport orderIdPassport;
    private boolean async;
    private int retType;
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");

    public ApiCallbackDecoder(ApiComposeCallback callback, boolean async, CyclicBarrier cyclicBarrier, OrderIdPassport orderIdPassport) {
        this.callback = callback;
        this.cyclicBarrier = cyclicBarrier;
        this.async = async;
        this.orderIdPassport = orderIdPassport;
    }

    public synchronized void handle(StompFrame stompFrame) {
        this.init(stompFrame);
        switch (this.retType) {
            case 1: {
                this.processGetOrderNoEnd();
                break;
            }
            case 2: {
                this.processPreviewOrderEnd();
                break;
            }
            case 3: {
                this.processPlaceOrderEnd();
                break;
            }
            case 4: {
                this.processCancelOrderEnd();
                break;
            }
            case 5: {
                this.processModifyOrderEnd();
                break;
            }
            case 6: {
                this.processGetAssetEnd();
                break;
            }
            case 7: {
                this.processGetPositionEnd();
                break;
            }
            case 8: {
                this.processGetAccountEnd();
                break;
            }
            case 10: {
                this.processPosition();
                break;
            }
            case 11: {
                this.processAsset();
                break;
            }
            case 9: {
                this.processOrderStatus();
                break;
            }
            case 101: {
                this.processMarketState();
                break;
            }
            case 102: {
                this.processAllSymbols();
                break;
            }
            case 103: {
                this.processAllSymbolNames();
                break;
            }
            case 104: {
                this.processBriefInfo();
                break;
            }
            case 105: {
                this.processStockDetail();
                break;
            }
            case 106: {
                this.processTimeline();
                break;
            }
            case 107: {
                this.processHourTradingTimeline();
                break;
            }
            case 108: {
                this.processKline();
                break;
            }
            case 109: {
                this.processTradingTick();
                break;
            }
            case 110: {
                this.processSubscribeQuoteChange();
                break;
            }
            case 111: {
                this.processGetSubscribedSymbols();
                break;
            }
            case 112: {
                this.processSubscribeEnd();
                break;
            }
            case 113: {
                this.processCancelSubscribeEnd();
                break;
            }
            case -1: {
                break;
            }
            default: {
                this.processDefault();
            }
        }
    }

    private void init(StompFrame stompFrame) {
        this.stompFrame = stompFrame;
        this.retType = stompFrame.headers().getInt((Object)"ret-type");
    }

    public ApiComposeCallback getCallback() {
        return this.callback;
    }

    private void processGetOrderNoEnd() {
        JSONObject jsonObject = JSON.parseObject((String)this.stompFrame.content().toString(DEFAULT_CHARSET));
        this.orderIdPassport.setOrderId(jsonObject.getIntValue("orderId"));
        this.callback.orderNoEnd(jsonObject);
        this.nonAsyncWait();
    }

    private void nonAsyncWait() {
        if (!this.async) {
            try {
                this.cyclicBarrier.await();
                this.cyclicBarrier.reset();
            }
            catch (InterruptedException e) {
                logger.error("interrupted exception", (Throwable)e);
            }
            catch (BrokenBarrierException e) {
                logger.error("broken barrier exception", (Throwable)e);
            }
        }
    }

    private void processPreviewOrderEnd() {
        this.callback.previewOrderEnd(JSON.parseObject((String)this.stompFrame.content().toString(DEFAULT_CHARSET)));
    }

    private void processPlaceOrderEnd() {
        this.callback.placeOrderEnd(JSON.parseObject((String)this.stompFrame.content().toString(DEFAULT_CHARSET)));
    }

    private void processCancelOrderEnd() {
        this.callback.cancelOrderEnd(JSON.parseObject((String)this.stompFrame.content().toString(DEFAULT_CHARSET)));
    }

    private void processModifyOrderEnd() {
        this.callback.modifyOrderEnd(JSON.parseObject((String)this.stompFrame.content().toString(DEFAULT_CHARSET)));
    }

    private void processGetAssetEnd() {
        this.callback.getAssetEnd(JSON.parseObject((String)this.stompFrame.content().toString(DEFAULT_CHARSET)));
    }

    private void processGetPositionEnd() {
        this.callback.getPositionEnd(JSON.parseObject((String)this.stompFrame.content().toString(DEFAULT_CHARSET)));
    }

    private void processGetAccountEnd() {
        this.callback.getAccountEnd(JSON.parseObject((String)this.stompFrame.content().toString(DEFAULT_CHARSET)));
    }

    private void processPosition() {
        String content = this.stompFrame.content().toString(DEFAULT_CHARSET);
        this.callback.positionChange(JSON.parseObject((String)content));
    }

    private void processAsset() {
        String content = this.stompFrame.content().toString(DEFAULT_CHARSET);
        this.callback.assetChange(JSONObject.parseObject((String)content));
    }

    private void processOrderStatus() {
        String content = this.stompFrame.content().toString(DEFAULT_CHARSET);
        this.callback.orderStatusChange(JSONObject.parseObject((String)content));
    }

    private void processMarketState() {
        String content = this.stompFrame.content().toString(DEFAULT_CHARSET);
        this.callback.getMarketStateEnd(JSONObject.parseObject((String)content));
    }

    private void processAllSymbols() {
        String content = this.stompFrame.content().toString(DEFAULT_CHARSET);
        this.callback.getAllSymbolsEnd(JSONObject.parseObject((String)content));
    }

    private void processAllSymbolNames() {
        String content = this.stompFrame.content().toString(DEFAULT_CHARSET);
        this.callback.getAllSymbolNamesEnd(JSONObject.parseObject((String)content));
    }

    private void processBriefInfo() {
        String content = this.stompFrame.content().toString(DEFAULT_CHARSET);
        this.callback.getBriefInfoEnd(JSONObject.parseObject((String)content));
    }

    private void processStockDetail() {
        String content = this.stompFrame.content().toString(DEFAULT_CHARSET);
        this.callback.getStockDetailEnd(JSONObject.parseObject((String)content));
    }

    private void processTimeline() {
        String content = this.stompFrame.content().toString(DEFAULT_CHARSET);
        this.callback.getTimelineEnd(JSONObject.parseObject((String)content));
    }

    private void processHourTradingTimeline() {
        String content = this.stompFrame.content().toString(DEFAULT_CHARSET);
        this.callback.getHourTradingTimelineEnd(JSONObject.parseObject((String)content));
    }

    private void processKline() {
        String content = this.stompFrame.content().toString(DEFAULT_CHARSET);
        this.callback.getKlineEnd(JSONObject.parseObject((String)content));
    }

    private void processTradingTick() {
        String content = this.stompFrame.content().toString(DEFAULT_CHARSET);
        this.callback.getTradeTickEnd(JSONObject.parseObject((String)content));
    }

    private void processSubscribeQuoteChange() {
        String content = this.stompFrame.content().toString(DEFAULT_CHARSET);
        this.callback.quoteChange(JSONObject.parseObject((String)content));
    }

    private void processGetSubscribedSymbols() {
        String content = this.stompFrame.content().toString(DEFAULT_CHARSET);
        this.callback.getSubscribedSymbolEnd((SubscribedSymbol)JSONObject.parseObject((String)content, SubscribedSymbol.class));
    }

    private void processSubscribeEnd() {
        String content = this.stompFrame.content().toString(DEFAULT_CHARSET);
        this.callback.subscribeEnd(JSONObject.parseObject((String)content));
    }

    private void processCancelSubscribeEnd() {
        String content = this.stompFrame.content().toString(DEFAULT_CHARSET);
        this.callback.cancelSubscribeEnd(JSONObject.parseObject((String)content));
    }

    private void processDefault() {
        logger.info("ret-type:{} cannot be processed.", (Object)this.retType);
    }
}

