/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.socket;

import com.tigerbrokers.stock.openapi.client.socket.ApiCallbackDecoder;
import com.tigerbrokers.stock.openapi.client.util.StompMessageUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdleTriggerHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(IdleTriggerHandler.class);
    private ApiCallbackDecoder apiCallbackDecoder = null;

    public IdleTriggerHandler(ApiCallbackDecoder decoder) {
        this.apiCallbackDecoder = decoder;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleState state = ((IdleStateEvent)evt).state();
            if (IdleState.WRITER_IDLE == state) {
                ctx.channel().writeAndFlush((Object)StompMessageUtil.buildCommonSendMessage("Heart_Beat"));
            } else if (IdleState.READER_IDLE == state) {
                log.warn("server time out:{}", (Object)ctx.channel().id().asLongText());
                if (this.apiCallbackDecoder != null) {
                    this.apiCallbackDecoder.serverHeartBeatTimeOut(ctx.channel().id().asLongText());
                }
            }
        } else {
            ctx.fireUserEventTriggered(evt);
        }
    }
}

