/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.util;

import com.tigerbrokers.stock.openapi.client.util.ApiLogger;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class NetworkUtil {
    private static final String GET_DEVICE_ERROR = "Please check if the network connection is disconnected";

    private NetworkUtil() {
    }

    public static String getDeviceId() {
        try {
            InetAddress inetAddress = NetworkUtil.getLocalHostLANAddress();
            byte[] mac = NetworkInterface.getByInetAddress(inetAddress).getHardwareAddress();
            if (mac == null) {
                ApiLogger.error(GET_DEVICE_ERROR);
                throw new RuntimeException(GET_DEVICE_ERROR);
            }
            StringBuilder deviceId = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                String str;
                if (i != 0) {
                    deviceId.append(":");
                }
                if ((str = Integer.toHexString(mac[i] & 0xFF)).length() == 1) {
                    deviceId.append(0);
                }
                deviceId.append(str);
            }
            return deviceId.toString();
        }
        catch (SocketException | UnknownHostException e) {
            ApiLogger.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private static InetAddress getLocalHostLANAddress() throws UnknownHostException {
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    if (inetAddress.isSiteLocalAddress()) {
                        return inetAddress;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddress;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return jdkSuppliedAddress;
        }
        catch (Exception e) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address: " + e);
            unknownHostException.initCause(e);
            throw unknownHostException;
        }
    }
}

