/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.socket;

import com.tigerbrokers.stock.openapi.client.socket.ApiAuthentication;
import com.tigerbrokers.stock.openapi.client.socket.ApiCallbackDecoder;
import com.tigerbrokers.stock.openapi.client.socket.ApiComposeCallback;
import com.tigerbrokers.stock.openapi.client.util.ApiCallbackDecoderUtils;
import com.tigerbrokers.stock.openapi.client.util.ApiLogger;
import com.tigerbrokers.stock.openapi.client.util.StompMessageUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.stomp.StompFrame;

@ChannelHandler.Sharable
public class WebSocketHandler
extends SimpleChannelInboundHandler<StompFrame> {
    private ApiAuthentication authentication;
    private ApiCallbackDecoder decoder;

    public WebSocketHandler(ApiAuthentication authentication, ApiComposeCallback callback) {
        this.authentication = authentication;
        this.decoder = new ApiCallbackDecoder(callback);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.writeAndFlush((Object)StompMessageUtil.buildConnectMessage(this.authentication.getTigerId(), this.authentication.getSign(), this.authentication.getVersion()));
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ApiLogger.info("netty channel inactive!");
        super.channelInactive(ctx);
        ctx.close();
    }

    public void channelRead0(ChannelHandlerContext ctx, StompFrame frame) throws Exception {
        ApiLogger.debug("received frame from server: {}", frame);
        ApiCallbackDecoderUtils.executor(ctx, frame, this.decoder);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ApiLogger.error("handler exception caught:", cause);
        ctx.close();
    }
}

