/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.websocket;

import com.tigerbrokers.stock.openapi.client.socket.ApiAuthentication;
import com.tigerbrokers.stock.openapi.client.socket.ApiCallbackDecoder;
import com.tigerbrokers.stock.openapi.client.socket.ApiComposeCallback;
import com.tigerbrokers.stock.openapi.client.util.ApiCallbackDecoderUtils;
import com.tigerbrokers.stock.openapi.client.util.ApiLogger;
import com.tigerbrokers.stock.openapi.client.util.StompMessageUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.stomp.StompFrame;
import io.netty.util.CharsetUtil;

@ChannelHandler.Sharable
public class WebSocketHandshakerHandler
extends SimpleChannelInboundHandler<Object> {
    private ApiAuthentication authentication;
    private ApiCallbackDecoder decoder;
    private WebSocketClientHandshaker handshaker;

    public WebSocketHandshakerHandler(ApiAuthentication authentication, ApiComposeCallback callback) {
        this.authentication = authentication;
        this.decoder = new ApiCallbackDecoder(callback);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
    }

    public void setHandshaker(WebSocketClientHandshaker handshaker) {
        this.handshaker = handshaker;
    }

    public WebSocketClientHandshaker getHandshaker() {
        return this.handshaker;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ApiLogger.info("netty channel inactive!\uff0cchannel:{}", ctx.channel());
        super.channelInactive(ctx);
        ctx.close();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ApiLogger.error("handler exception caught:", cause);
        ctx.close();
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        ApiLogger.info("WebSocketHandshakerHandler channelRead0  {}", this.handshaker.isHandshakeComplete());
        Channel ch = ctx.channel();
        if (!this.handshaker.isHandshakeComplete()) {
            FullHttpResponse response = (FullHttpResponse)msg;
            this.handshaker.finishHandshake(ch, response);
            ctx.writeAndFlush((Object)StompMessageUtil.buildConnectMessage(this.authentication.getTigerId(), this.authentication.getSign(), this.authentication.getVersion()));
            ApiLogger.info("WebSocket Client connected! response headers[sec-websocket-extensions]:{}", response.headers());
        } else {
            if (msg instanceof FullHttpResponse) {
                FullHttpResponse response = (FullHttpResponse)msg;
                throw new IllegalStateException("Unexpected FullHttpResponse (getStatus=" + response.status() + ", content=" + response.content().toString(CharsetUtil.UTF_8) + ')');
            }
            StompFrame stompFrame = (StompFrame)msg;
            ApiLogger.debug("received stop frame from server: {}", stompFrame);
            ApiCallbackDecoderUtils.executor(ctx, stompFrame, this.decoder);
        }
    }
}

