/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.https.request.financial;

import com.tigerbrokers.stock.openapi.client.https.domain.financial.model.FinancialDailyModel;
import com.tigerbrokers.stock.openapi.client.https.request.TigerCommonRequest;
import com.tigerbrokers.stock.openapi.client.https.request.TigerRequest;
import com.tigerbrokers.stock.openapi.client.https.response.financial.FinancialDailyResponse;
import com.tigerbrokers.stock.openapi.client.struct.enums.Market;
import com.tigerbrokers.stock.openapi.client.struct.enums.TimeZoneId;
import com.tigerbrokers.stock.openapi.client.util.DateUtils;
import java.util.Date;
import java.util.List;

public class FinancialDailyRequest
extends TigerCommonRequest
implements TigerRequest<FinancialDailyResponse> {
    public FinancialDailyRequest() {
        this.setApiMethodName("financial_daily");
        this.setApiVersion("1.0");
    }

    public static FinancialDailyRequest newRequest(List<String> symbols, List<String> fields, Date beginDate, Date endDate) {
        return FinancialDailyRequest.newRequest(symbols, Market.US, fields, beginDate, endDate);
    }

    public static FinancialDailyRequest newRequest(List<String> symbols, List<String> fields, String beginDate, String endDate) {
        return FinancialDailyRequest.newRequest(symbols, Market.US, fields, DateUtils.getZoneDate(beginDate, TimeZoneId.Shanghai), DateUtils.getZoneDate(endDate, TimeZoneId.Shanghai));
    }

    public static FinancialDailyRequest newRequest(List<String> symbols, Market market, List<String> fields, Date beginDate, Date endDate) {
        FinancialDailyRequest request = new FinancialDailyRequest();
        FinancialDailyModel model = new FinancialDailyModel();
        model.setSymbols(symbols);
        model.setMarket(market);
        model.setFields(fields);
        model.setBeginDate(beginDate);
        model.setEndDate(endDate);
        request.setApiModel(model);
        return request;
    }

    @Override
    public Class<FinancialDailyResponse> getResponseClass() {
        return FinancialDailyResponse.class;
    }
}

