/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.util;

import com.tigerbrokers.stock.openapi.client.socket.ApiCallbackDecoder;
import com.tigerbrokers.stock.openapi.client.socket.IdleTriggerHandler;
import com.tigerbrokers.stock.openapi.client.socket.WebSocketClient;
import com.tigerbrokers.stock.openapi.client.util.StringUtils;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.stomp.StompFrame;
import io.netty.handler.codec.stomp.StompHeaders;
import io.netty.handler.timeout.IdleStateHandler;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;

public class ApiCallbackDecoderUtils {
    public static final String IDLE_STATE_HANDLER = "idleStateHandler";
    public static final String IDLE_TRIGGER_HANDLER = "idleTriggerHandler";

    public static void executor(ChannelHandlerContext ctx, StompFrame frame, ApiCallbackDecoder decoder) throws Exception {
        if (null == decoder || null == ctx) {
            return;
        }
        switch (frame.command()) {
            case CONNECTED: {
                if (decoder.getCallback() != null) {
                    if (frame.headers().contains((Object)StompHeaders.HEART_BEAT)) {
                        String value = frame.headers().getAsString((CharSequence)StompHeaders.HEART_BEAT);
                        if (!StringUtils.isEmpty(value)) {
                            String[] arrayValue = value.split(",");
                            if (null != arrayValue && arrayValue.length >= 2) {
                                int serverReceiveIterval;
                                int serverSendInterval = StringUtils.isEmpty(arrayValue[0]) ? 0 : Integer.valueOf(arrayValue[0]);
                                int n = serverReceiveIterval = StringUtils.isEmpty(arrayValue[1]) ? 0 : Integer.valueOf(arrayValue[1]);
                                if ((serverSendInterval > 0 || serverReceiveIterval > 0) && null == ctx.channel().pipeline().get(IDLE_STATE_HANDLER)) {
                                    serverSendInterval = serverSendInterval == 0 ? 0 : serverSendInterval + 1000;
                                    serverReceiveIterval = serverReceiveIterval == 0 ? 0 : serverReceiveIterval - 1000;
                                    ctx.channel().pipeline().addBefore("stompEncoder", IDLE_STATE_HANDLER, (ChannelHandler)new IdleStateHandler((long)serverSendInterval, (long)serverReceiveIterval, 0L, TimeUnit.MILLISECONDS));
                                    ctx.channel().pipeline().addAfter(IDLE_STATE_HANDLER, IDLE_TRIGGER_HANDLER, (ChannelHandler)new IdleTriggerHandler(decoder));
                                }
                                decoder.getCallback().connectAck(serverSendInterval, serverReceiveIterval);
                            } else {
                                decoder.getCallback().connectAck();
                            }
                        } else {
                            decoder.getCallback().connectAck();
                        }
                    } else {
                        decoder.getCallback().connectAck();
                    }
                }
                WebSocketClient.connectCountDown.countDown();
                break;
            }
            case MESSAGE: {
                decoder.handle(frame);
                break;
            }
            case RECEIPT: {
                break;
            }
            case ERROR: {
                if (decoder.getCallback() == null) break;
                decoder.getCallback().error(frame.content().toString(Charset.defaultCharset()));
                break;
            }
            case DISCONNECT: {
                if (decoder.getCallback() != null) {
                    decoder.getCallback().connectionClosed();
                }
                ctx.close();
                break;
            }
        }
    }
}

