/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.https.request.financial;

import com.tigerbrokers.stock.openapi.client.https.domain.financial.model.FinancialReportModel;
import com.tigerbrokers.stock.openapi.client.https.request.TigerCommonRequest;
import com.tigerbrokers.stock.openapi.client.https.request.TigerRequest;
import com.tigerbrokers.stock.openapi.client.https.response.financial.FinancialReportResponse;
import com.tigerbrokers.stock.openapi.client.struct.enums.FinancialPeriodType;
import com.tigerbrokers.stock.openapi.client.struct.enums.Market;
import java.util.List;

public class FinancialReportRequest
extends TigerCommonRequest
implements TigerRequest<FinancialReportResponse> {
    public FinancialReportRequest() {
        this.setApiMethodName("financial_report");
        this.setApiVersion("1.0");
    }

    public static FinancialReportRequest newRequest(List<String> symbols, List<String> fields) {
        return FinancialReportRequest.newRequest(symbols, Market.US, fields, FinancialPeriodType.Quarterly);
    }

    public static FinancialReportRequest newRequest(List<String> symbols, List<String> fields, FinancialPeriodType periodType) {
        return FinancialReportRequest.newRequest(symbols, Market.US, fields, periodType);
    }

    public static FinancialReportRequest newRequest(List<String> symbols, Market market, List<String> fields, FinancialPeriodType periodType) {
        FinancialReportRequest request = new FinancialReportRequest();
        FinancialReportModel model = new FinancialReportModel();
        model.setSymbols(symbols);
        model.setMarket(market);
        model.setFields(fields);
        model.setPeriodType(periodType);
        request.setApiModel(model);
        return request;
    }

    @Override
    public Class<FinancialReportResponse> getResponseClass() {
        return FinancialReportResponse.class;
    }
}

