/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.socket;

import com.tigerbrokers.stock.openapi.client.socket.ApiAuthentication;
import com.tigerbrokers.stock.openapi.client.socket.ApiComposeCallback;
import com.tigerbrokers.stock.openapi.client.socket.SubscribeAsyncApi;
import com.tigerbrokers.stock.openapi.client.socket.WebSocketHandler;
import com.tigerbrokers.stock.openapi.client.struct.ClientHeartBeatData;
import com.tigerbrokers.stock.openapi.client.struct.enums.Exchange;
import com.tigerbrokers.stock.openapi.client.struct.enums.QuoteSubject;
import com.tigerbrokers.stock.openapi.client.struct.enums.Subject;
import com.tigerbrokers.stock.openapi.client.util.ApiLogger;
import com.tigerbrokers.stock.openapi.client.util.StompMessageUtil;
import com.tigerbrokers.stock.openapi.client.util.StringUtils;
import com.tigerbrokers.stock.openapi.client.websocket.WebSocketHandshakerHandler;
import com.tigerbrokers.stock.openapi.client.websocket.WebSocketStompFrameDecoder;
import com.tigerbrokers.stock.openapi.client.websocket.WebSocketStompFrameEncoder;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.stomp.StompFrame;
import io.netty.handler.codec.stomp.StompHeaders;
import io.netty.handler.codec.stomp.StompSubframeAggregator;
import io.netty.handler.codec.stomp.StompSubframeDecoder;
import io.netty.handler.codec.stomp.StompSubframeEncoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.internal.ConcurrentSet;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLException;

public class WebSocketClient
implements SubscribeAsyncApi {
    public static final String STOMP_ENCODER = "stompEncoder";
    public static final String STOMP_DECODER = "stompDecoder";
    private String url;
    private ApiAuthentication authentication;
    private ApiComposeCallback apiComposeCallback;
    private Set<Subject> subscribeList = new CopyOnWriteArraySet<Subject>();
    private Set<String> subscribeSymbols = new ConcurrentSet();
    public static CountDownLatch connectCountDown = new CountDownLatch(1);
    private EventLoopGroup group = null;
    private Bootstrap bootstrap = null;
    private Channel channel = null;
    private ChannelFuture future = null;
    private boolean inited = false;
    private volatile ScheduledFuture<?> reconnectExecutorFuture = null;
    private static final ScheduledThreadPoolExecutor reconnectExecutorService = new ScheduledThreadPoolExecutor(2);
    private long lastConnectedTime = System.currentTimeMillis();
    private AtomicInteger reconnectCount = new AtomicInteger(0);
    private AtomicBoolean reconnectErrorLogFlag = new AtomicBoolean(false);
    private static final int CONNECT_TIMEOUT = 3000;
    private static final long SHUTDOWN_TIMEOUT = 900000L;
    private static final int RECONNECT_WARNING_PERIOD = 1800;
    private int clientSendInterval = 0;
    private int clientReceiveInterval = 0;
    private static final int CLIENT_SEND_INTERVAL_MIN = 3000;
    private static final int CLIENT_RECEIVE_INTERVAL_MIN = 5000;

    public WebSocketClient(String url, ApiAuthentication authentication, ApiComposeCallback apiComposeCallback) {
        this.url = url;
        this.authentication = authentication;
        this.apiComposeCallback = apiComposeCallback;
        this.clientSendInterval = 10000;
        this.init();
    }

    public WebSocketClient(String url, ApiAuthentication authentication, ApiComposeCallback apiComposeCallback, ClientHeartBeatData clientHeartBeatData) {
        this.url = url;
        this.authentication = authentication;
        this.apiComposeCallback = apiComposeCallback;
        if (clientHeartBeatData.getSendInterval() >= 0) {
            int n = this.clientSendInterval = clientHeartBeatData.getSendInterval() >= 3000 ? clientHeartBeatData.getSendInterval() : 3000;
        }
        if (clientHeartBeatData.getReceiveInterval() >= 0) {
            this.clientReceiveInterval = clientHeartBeatData.getReceiveInterval() >= 5000 ? clientHeartBeatData.getReceiveInterval() : 5000;
        }
        this.init();
    }

    private void init() {
        final InetSocketAddress address = this.getServerAddress();
        if (address == null) {
            throw new RuntimeException("get connect address error.");
        }
        this.group = new NioEventLoopGroup(1);
        this.bootstrap = new Bootstrap();
        final int port = address.getPort();
        ((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.group)).option(ChannelOption.TCP_NODELAY, (Object)true)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws SSLException {
                ChannelPipeline p = ch.pipeline();
                SslContext sslCtx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
                p.addLast(new ChannelHandler[]{sslCtx.newHandler(ch.alloc(), address.getHostName(), address.getPort())});
                if (port == 8887 || port == 8889) {
                    p.addLast("websocketCodec", (ChannelHandler)new HttpClientCodec());
                    p.addLast("websocketAggregator", (ChannelHandler)new HttpObjectAggregator(65535));
                    p.addLast(WebSocketClient.STOMP_ENCODER, (ChannelHandler)new WebSocketStompFrameDecoder());
                    p.addLast(WebSocketClient.STOMP_DECODER, (ChannelHandler)new WebSocketStompFrameEncoder());
                    p.addLast("stompAggregator", (ChannelHandler)new StompSubframeAggregator(65535));
                } else {
                    WebSocketHandler handler = new WebSocketHandler(WebSocketClient.this.authentication, WebSocketClient.this.apiComposeCallback, WebSocketClient.this.clientSendInterval, WebSocketClient.this.clientReceiveInterval);
                    p.addLast(WebSocketClient.STOMP_ENCODER, (ChannelHandler)new StompSubframeEncoder());
                    p.addLast(WebSocketClient.STOMP_DECODER, (ChannelHandler)new StompSubframeDecoder());
                    p.addLast("aggregator", (ChannelHandler)new StompSubframeAggregator(65535));
                    p.addLast("webSocketHandler", (ChannelHandler)handler);
                }
            }
        });
        this.apiComposeCallback.client(this);
        this.inited = true;
    }

    public void connect() {
        try {
            if (this.isConnected()) {
                return;
            }
            this.initReconnectCommand();
            this.doConnect();
            if (!this.isConnected()) {
                throw new Exception("Failed connect to server.");
            }
            ApiLogger.info("Success connect to server, channel is: {}", this.channel);
            this.reconnectCount.set(0);
            this.reconnectErrorLogFlag.set(false);
        }
        catch (Throwable e) {
            ApiLogger.error("Failed connect to server, cause: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConnect() {
        block21: {
            try {
                InetSocketAddress address;
                long start = System.currentTimeMillis();
                if (!this.inited) {
                    this.init();
                }
                if ((address = this.getServerAddress()) == null) {
                    throw new RuntimeException("get connect address error.");
                }
                this.future = this.bootstrap.connect((SocketAddress)address).sync();
                boolean completed = this.future.awaitUninterruptibly(3000L, TimeUnit.MILLISECONDS);
                if (completed && this.future.isSuccess()) {
                    Channel newChannel = this.future.channel();
                    URI uri = null;
                    try {
                        uri = new URI(this.url);
                        Channel oldChannel = this.channel;
                        if (oldChannel != null) {
                            ApiLogger.info("close old netty channel:{} , create new netty channel:{} ", oldChannel, newChannel);
                            oldChannel.close();
                        }
                        break block21;
                    }
                    finally {
                        this.channel = newChannel;
                        if (address.getPort() == 8887 || address.getPort() == 8889) {
                            Channel channel = this.channel;
                            synchronized (channel) {
                                WebSocketHandshakerHandler webSocketHandshakerHandler = new WebSocketHandshakerHandler(this.authentication, this.apiComposeCallback, this.clientSendInterval, this.clientReceiveInterval);
                                DefaultHttpHeaders httpHeaders = new DefaultHttpHeaders();
                                WebSocketClientHandshaker handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)uri, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)true, (HttpHeaders)httpHeaders);
                                webSocketHandshakerHandler.setHandshaker(handshaker);
                                this.channel.pipeline().addLast("handshakerHandler", (ChannelHandler)webSocketHandshakerHandler);
                                webSocketHandshakerHandler.setHandshaker(handshaker);
                                ChannelPromise channelFuture = (ChannelPromise)handshaker.handshake(this.channel);
                                channelFuture.sync();
                            }
                        }
                        connectCountDown.await(5000L, TimeUnit.MILLISECONDS);
                    }
                }
                if (this.future.cause() != null) {
                    throw new Exception("client failed to connect to server, error message is:" + this.future.cause().getMessage(), this.future.cause());
                }
                throw new Exception("client failed to connect to server, client-side timeout: " + (System.currentTimeMillis() - start) + "ms ");
            }
            catch (Exception e) {
                ApiLogger.error("client failed to connect to server: ", e);
            }
            finally {
                if (!this.isConnected()) {
                    this.future.cancel(true);
                }
            }
        }
    }

    private InetSocketAddress getServerAddress() {
        URI uri;
        if (StringUtils.isEmpty(this.url)) {
            ApiLogger.error("url is empty.");
            return null;
        }
        try {
            uri = new URI(this.url);
        }
        catch (URISyntaxException e) {
            ApiLogger.error("uri syntax exception:", e);
            return null;
        }
        return new InetSocketAddress(uri.getHost(), uri.getPort());
    }

    public void disconnect() {
        this.sendDisconnectFrame();
        this.destroyConnectCommand();
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (Throwable e) {
            ApiLogger.error(e.getMessage(), e);
        }
        try {
            this.group.shutdownGracefully();
        }
        catch (Throwable t) {
            ApiLogger.error(t.getMessage());
        }
        finally {
            this.inited = false;
        }
    }

    private synchronized void sendDisconnectFrame() {
        if (!this.isConnected()) {
            this.notConnect();
            return;
        }
        StompFrame disconnectFrame = StompMessageUtil.buildDisconnectMessage(this.authentication.getTigerId());
        ChannelFuture channelFuture = this.channel.writeAndFlush((Object)disconnectFrame);
        try {
            channelFuture.sync();
            ApiLogger.info("sendDisconnectFrame finished, tiger id:{}", this.authentication.getTigerId());
        }
        catch (InterruptedException e) {
            ApiLogger.error("sendDisconnectFrame error, tiger id:{}", (Object)this.authentication.getTigerId(), (Object)e);
        }
    }

    private synchronized void destroyConnectCommand() {
        try {
            if (this.reconnectExecutorFuture != null && !this.reconnectExecutorFuture.isDone()) {
                this.reconnectExecutorFuture.cancel(true);
                reconnectExecutorService.purge();
                reconnectExecutorService.shutdownNow();
            }
        }
        catch (Throwable e) {
            ApiLogger.error(e.getMessage(), e);
        }
    }

    public boolean isConnected() {
        if (this.channel == null) {
            return false;
        }
        return this.channel.isActive();
    }

    private synchronized void initReconnectCommand() {
        if (this.reconnectExecutorFuture == null || this.reconnectExecutorFuture.isCancelled()) {
            Runnable reconnectCommand = () -> {
                block5: {
                    try {
                        if (!this.isConnected()) {
                            this.connect();
                        } else {
                            this.lastConnectedTime = System.currentTimeMillis();
                        }
                    }
                    catch (Throwable t) {
                        if (System.currentTimeMillis() - this.lastConnectedTime > 900000L && !this.reconnectErrorLogFlag.get()) {
                            this.reconnectErrorLogFlag.set(true);
                            ApiLogger.error("client reconnect to server error, lastConnectedTime:{}, currentTime:{}", this.lastConnectedTime, System.currentTimeMillis(), t);
                            return;
                        }
                        if (this.reconnectCount.getAndIncrement() % 1800 != 0) break block5;
                        ApiLogger.error("client reconnect to server error, lastConnectedTime:{}, currentTime:{}", this.lastConnectedTime, System.currentTimeMillis(), t);
                    }
                }
            };
            this.reconnectExecutorFuture = reconnectExecutorService.scheduleWithFixedDelay(reconnectCommand, 3000L, 10000L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public String subscribe(Subject subject, List<String> focusKeys) {
        if (!this.isConnected()) {
            this.notConnect();
            return null;
        }
        StompFrame frame = StompMessageUtil.buildSubscribeMessage(subject, new HashSet<String>(focusKeys));
        this.channel.writeAndFlush((Object)frame);
        this.subscribeList.add(subject);
        return frame.headers().getAsString((CharSequence)StompHeaders.ID);
    }

    @Override
    public String subscribe(Subject subject) {
        if (!this.isConnected()) {
            this.notConnect();
            return null;
        }
        StompFrame frame = StompMessageUtil.buildSubscribeMessage(subject);
        this.channel.writeAndFlush((Object)frame);
        this.subscribeList.add(subject);
        return frame.headers().getAsString((CharSequence)StompHeaders.ID);
    }

    @Override
    public String cancelSubscribe(Subject subject) {
        if (!this.isConnected()) {
            this.notConnect();
            return null;
        }
        StompFrame frame = StompMessageUtil.buildUnSubscribeMessage(subject);
        this.channel.writeAndFlush((Object)frame);
        this.subscribeList.remove((Object)subject);
        return frame.headers().getAsString((CharSequence)StompHeaders.ID);
    }

    @Override
    public String subscribeQuote(Set<String> symbols) {
        return this.subscribeQuote(symbols, QuoteSubject.Quote);
    }

    @Override
    public String subscribeQuote(Set<String> symbols, List<String> focusKeys) {
        return this.subscribeQuote(symbols, QuoteSubject.Quote, focusKeys);
    }

    @Override
    public String cancelSubscribeQuote(Set<String> symbols) {
        return this.cancelSubscribeQuote(symbols, QuoteSubject.Quote);
    }

    @Override
    public String subscribeOption(Set<String> symbols) {
        return this.subscribeQuote(symbols, QuoteSubject.Option);
    }

    @Override
    public String cancelSubscribeOption(Set<String> symbols) {
        return this.cancelSubscribeQuote(symbols, QuoteSubject.Option);
    }

    @Override
    public String subscribeFuture(Set<String> symbols) {
        return this.subscribeQuote(symbols, QuoteSubject.Future);
    }

    @Override
    public String cancelSubscribeFuture(Set<String> symbols) {
        return this.cancelSubscribeQuote(symbols, QuoteSubject.Future);
    }

    @Override
    public String subscribeAskBid(Set<String> symbols, Exchange exchange) {
        if (!this.isConnected()) {
            this.notConnect();
            return null;
        }
        StompFrame frame = StompMessageUtil.buildSubscribeMessage(symbols, exchange, QuoteSubject.AskBid);
        this.channel.writeAndFlush((Object)frame);
        this.subscribeSymbols.addAll(symbols);
        ApiLogger.info("send subscribe [{}] message, symbols:{}", (Object)QuoteSubject.AskBid, symbols);
        return frame.headers().getAsString((CharSequence)StompHeaders.ID);
    }

    @Override
    public String cancelSubscribeAskBid(Set<String> symbols) {
        return this.cancelSubscribeQuote(symbols, QuoteSubject.AskBid);
    }

    private String subscribeQuote(Set<String> symbols, QuoteSubject subject) {
        return this.subscribeQuote(symbols, subject, null);
    }

    private String subscribeQuote(Set<String> symbols, QuoteSubject subject, List<String> focusKeys) {
        if (!this.isConnected()) {
            this.notConnect();
            return null;
        }
        StompFrame frame = focusKeys == null ? StompMessageUtil.buildSubscribeMessage(symbols, subject) : StompMessageUtil.buildSubscribeMessage(symbols, subject, new HashSet<String>(focusKeys));
        this.channel.writeAndFlush((Object)frame);
        this.subscribeSymbols.addAll(symbols);
        ApiLogger.info("send subscribe [{}] message, symbols:{},focusKeys:{}", (Object)subject, symbols, focusKeys);
        return frame.headers().getAsString((CharSequence)StompHeaders.ID);
    }

    private String cancelSubscribeQuote(Set<String> symbols, QuoteSubject subject) {
        if (!this.isConnected()) {
            this.notConnect();
            return null;
        }
        StompFrame frame = StompMessageUtil.buildUnSubscribeMessage(symbols, subject);
        this.channel.writeAndFlush((Object)frame);
        this.subscribeSymbols.removeAll(symbols);
        ApiLogger.info("send cancel subscribe [{}] message, symbols:{}.", (Object)subject, symbols);
        return frame.headers().getAsString((CharSequence)StompHeaders.ID);
    }

    @Override
    public String getSubscribedSymbols() {
        return this.sendMessage(110, null);
    }

    private String sendMessage(int reqType, String message) {
        if (!this.isConnected()) {
            this.notConnect();
            return null;
        }
        ApiLogger.info("reqType:{},send message:{}", reqType, message);
        StompFrame frame = StompMessageUtil.buildSendMessage(reqType, message);
        this.channel.writeAndFlush((Object)frame);
        return frame.headers().getAsString((CharSequence)StompHeaders.ID);
    }

    private void notConnect() {
        ApiLogger.info("connection is closed.");
    }
}

