/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.util;

import com.tigerbrokers.stock.openapi.client.struct.enums.AccountType;
import com.tigerbrokers.stock.openapi.client.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountUtil {
    private static final Logger log = LoggerFactory.getLogger(AccountUtil.class);

    public static boolean isOmnibusAccount(String account) {
        if (StringUtils.isEmpty(account)) {
            return false;
        }
        try {
            return StringUtils.isNumeric(account) && account.length() >= 6 && account.length() <= 8;
        }
        catch (Exception e) {
            log.error("isOmnibusAccount {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    public static boolean isGlobalAccount(String account) {
        if (StringUtils.isEmpty(account)) {
            return false;
        }
        return account.startsWith("U") || account.startsWith("DU") || account.startsWith("F") || account.startsWith("DF");
    }

    public static AccountType getAccountType(String account) {
        if (AccountUtil.isGlobalAccount(account)) {
            return AccountType.GLOBAL;
        }
        if (AccountUtil.isOmnibusAccount(account)) {
            return AccountType.STANDARD;
        }
        return AccountType.PAPER;
    }
}

