/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.https.domain.contract.item;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.parser.Feature;
import com.tigerbrokers.stock.openapi.client.TigerApiException;
import com.tigerbrokers.stock.openapi.client.https.domain.ApiModel;
import com.tigerbrokers.stock.openapi.client.https.domain.future.item.FutureContractItem;
import com.tigerbrokers.stock.openapi.client.struct.OptionSymbol;
import com.tigerbrokers.stock.openapi.client.struct.enums.Currency;
import com.tigerbrokers.stock.openapi.client.struct.enums.Market;
import com.tigerbrokers.stock.openapi.client.struct.enums.SecType;
import com.tigerbrokers.stock.openapi.client.util.FastJsonBooleanDeserializer;
import com.tigerbrokers.stock.openapi.client.util.SymbolUtil;
import java.util.List;

public class ContractItem
extends ApiModel {
    private Integer contractId;
    private String identifier;
    private String symbol;
    private String secType;
    private String expiry;
    private String contractMonth;
    private Double strike;
    private String right;
    private Double multiplier;
    private String exchange;
    private String market;
    private String primaryExchange;
    private String currency;
    private String localSymbol;
    private String tradingClass;
    private String name;
    @Deprecated
    private Integer status;
    private Boolean tradeable;
    private Double minTick;
    private Boolean marginable;
    @Deprecated
    private Double shortMargin;
    private Double shortInitialMargin;
    private Double shortMaintenanceMargin;
    private Double shortFeeRate;
    @JSONField(deserializeUsing=FastJsonBooleanDeserializer.class)
    private Boolean shortable;
    private Long shortableCount;
    private Double longInitialMargin;
    private Double longMaintenanceMargin;
    private String lastTradingDate;
    private String firstNoticeDate;
    private Long lastBiddingCloseTime;
    @Deprecated
    private Boolean trade;
    private Boolean continuous;
    private String type;
    private String ibCode;

    public Integer getContractId() {
        return this.contractId;
    }

    public void setContractId(Integer contractId) {
        this.contractId = contractId;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getSecType() {
        return this.secType;
    }

    public void setSecType(String secType) {
        this.secType = secType;
    }

    public String getExpiry() {
        return this.expiry;
    }

    public void setExpiry(String expiry) {
        this.expiry = expiry;
    }

    public String getContractMonth() {
        return this.contractMonth;
    }

    public void setContractMonth(String contractMonth) {
        this.contractMonth = contractMonth;
    }

    public Double getStrike() {
        return this.strike;
    }

    public void setStrike(Double strike) {
        this.strike = strike;
    }

    public String getRight() {
        return this.right;
    }

    public void setRight(String right) {
        this.right = right;
    }

    public Double getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(Double multiplier) {
        this.multiplier = multiplier;
    }

    public String getExchange() {
        return this.exchange;
    }

    public void setExchange(String exchange) {
        this.exchange = exchange;
    }

    public String getMarket() {
        return this.market;
    }

    public void setMarket(String market) {
        this.market = market;
    }

    public String getPrimaryExchange() {
        return this.primaryExchange;
    }

    public void setPrimaryExchange(String primaryExchange) {
        this.primaryExchange = primaryExchange;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getLocalSymbol() {
        return this.localSymbol;
    }

    public void setLocalSymbol(String localSymbol) {
        this.localSymbol = localSymbol;
    }

    public String getTradingClass() {
        return this.tradingClass;
    }

    public void setTradingClass(String tradingClass) {
        this.tradingClass = tradingClass;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Deprecated
    public Integer getStatus() {
        return this.status;
    }

    @Deprecated
    public void setStatus(Integer status) {
        this.status = status;
    }

    public Boolean isTradeable() {
        return this.tradeable;
    }

    public void setTradeable(Boolean tradeable) {
        this.tradeable = tradeable;
    }

    public Double getMinTick() {
        return this.minTick;
    }

    public void setMinTick(Double minTick) {
        this.minTick = minTick;
    }

    public Boolean isMarginable() {
        return this.marginable;
    }

    public void setMarginable(Boolean marginable) {
        this.marginable = marginable;
    }

    public Double getShortMargin() {
        return this.shortMargin;
    }

    public void setShortMargin(Double shortMargin) {
        this.shortMargin = shortMargin;
    }

    public Double getShortInitialMargin() {
        return this.shortInitialMargin;
    }

    public void setShortInitialMargin(Double shortInitialMargin) {
        this.shortInitialMargin = shortInitialMargin;
    }

    public Double getShortMaintenanceMargin() {
        return this.shortMaintenanceMargin;
    }

    public void setShortMaintenanceMargin(Double shortMaintenanceMargin) {
        this.shortMaintenanceMargin = shortMaintenanceMargin;
    }

    public Double getShortFeeRate() {
        return this.shortFeeRate;
    }

    public void setShortFeeRate(Double shortFeeRate) {
        this.shortFeeRate = shortFeeRate;
    }

    public Boolean isShortable() {
        return this.shortable;
    }

    public void setShortable(Boolean shortable) {
        this.shortable = shortable;
    }

    public Long getShortableCount() {
        return this.shortableCount;
    }

    public void setShortableCount(Long shortableCount) {
        this.shortableCount = shortableCount;
    }

    public Double getLongInitialMargin() {
        return this.longInitialMargin;
    }

    public void setLongInitialMargin(Double longInitialMargin) {
        this.longInitialMargin = longInitialMargin;
    }

    public Double getLongMaintenanceMargin() {
        return this.longMaintenanceMargin;
    }

    public void setLongMaintenanceMargin(Double longMaintenanceMargin) {
        this.longMaintenanceMargin = longMaintenanceMargin;
    }

    public String getLastTradingDate() {
        return this.lastTradingDate;
    }

    public void setLastTradingDate(String lastTradingDate) {
        this.lastTradingDate = lastTradingDate;
    }

    public String getFirstNoticeDate() {
        return this.firstNoticeDate;
    }

    public void setFirstNoticeDate(String firstNoticeDate) {
        this.firstNoticeDate = firstNoticeDate;
    }

    public Long getLastBiddingCloseTime() {
        return this.lastBiddingCloseTime;
    }

    public void setLastBiddingCloseTime(Long lastBiddingCloseTime) {
        this.lastBiddingCloseTime = lastBiddingCloseTime;
    }

    @Deprecated
    public Boolean isTrade() {
        return this.trade;
    }

    public void setTrade(Boolean trade) {
        this.trade = trade;
    }

    public Boolean isContinuous() {
        return this.continuous;
    }

    public void setContinuous(Boolean continuous) {
        this.continuous = continuous;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getIbCode() {
        return this.ibCode;
    }

    public void setIbCode(String ibCode) {
        this.ibCode = ibCode;
    }

    public String toString() {
        return "ContractItem{contractId=" + this.contractId + ", identifier='" + this.identifier + '\'' + ", symbol='" + this.symbol + '\'' + ", secType='" + this.secType + '\'' + ", expiry='" + this.expiry + '\'' + ", contractMonth='" + this.contractMonth + '\'' + ", strike=" + this.strike + ", right='" + this.right + '\'' + ", multiplier=" + this.multiplier + ", exchange='" + this.exchange + '\'' + ", market='" + this.market + '\'' + ", primaryExchange='" + this.primaryExchange + '\'' + ", currency='" + this.currency + '\'' + ", localSymbol='" + this.localSymbol + '\'' + ", tradingClass='" + this.tradingClass + '\'' + ", name='" + this.name + '\'' + ", tradeable=" + this.tradeable + ", minTick=" + this.minTick + ", marginable=" + this.marginable + ", shortableCount=" + this.shortableCount + ", shortInitialMargin=" + this.shortInitialMargin + ", shortMaintenanceMargin=" + this.shortMaintenanceMargin + ", shortFeeRate=" + this.shortFeeRate + ", longInitialMargin=" + this.longInitialMargin + ", longMaintenanceMargin=" + this.longMaintenanceMargin + ", lastTradingDate='" + this.lastTradingDate + '\'' + ", firstNoticeDate='" + this.firstNoticeDate + '\'' + ", lastBiddingCloseTime=" + this.lastBiddingCloseTime + ", ibCode=" + this.ibCode + ", type=" + this.type + ", trade=" + this.trade + ", continuous=" + this.continuous + '}';
    }

    public static ContractItem convert(FutureContractItem futureContractItem) {
        ContractItem contractItem = new ContractItem();
        contractItem.setSecType(SecType.FUT.name());
        contractItem.setSymbol(futureContractItem.getContractCode());
        contractItem.setType(futureContractItem.getType());
        contractItem.setIbCode(futureContractItem.getIbCode());
        contractItem.setName(futureContractItem.getName());
        contractItem.setContractMonth(futureContractItem.getContractMonth());
        contractItem.setExchange(futureContractItem.getExchangeCode());
        contractItem.setMultiplier(futureContractItem.getMultiplier() == null ? null : Double.valueOf(futureContractItem.getMultiplier().doubleValue()));
        contractItem.setMinTick(futureContractItem.getMinTick() == null ? null : Double.valueOf(futureContractItem.getMinTick().doubleValue()));
        contractItem.setExpiry(futureContractItem.getLastTradingDate());
        contractItem.setFirstNoticeDate(futureContractItem.getFirstNoticeDate());
        contractItem.setLastBiddingCloseTime(futureContractItem.getLastBiddingCloseTime());
        contractItem.setCurrency(futureContractItem.getCurrency());
        contractItem.setTrade(futureContractItem.isTrade());
        contractItem.setContinuous(futureContractItem.isContinuous());
        return contractItem;
    }

    public static ContractItem buildStockContract(String symbol, String currency) {
        ContractItem contractItem = new ContractItem();
        contractItem.setSecType(SecType.STK.name());
        contractItem.setSymbol(symbol);
        contractItem.setCurrency(currency);
        return contractItem;
    }

    public static ContractItem buildOptionContract(String identifier) throws TigerApiException {
        ContractItem contractItem = new ContractItem();
        contractItem.setSecType(SecType.OPT.name());
        OptionSymbol optionSymbol = SymbolUtil.convertToOptionSymbolObject(identifier);
        contractItem.setSymbol(optionSymbol.getSymbol());
        contractItem.setExpiry(optionSymbol.getExpiry());
        contractItem.setStrike(Double.parseDouble(optionSymbol.getStrike()));
        contractItem.setRight(optionSymbol.getRight());
        return contractItem;
    }

    public static ContractItem buildOptionContract(String symbol, String expiry, Double strike, String right) {
        ContractItem contractItem = new ContractItem();
        contractItem.setSecType(SecType.OPT.name());
        contractItem.setSymbol(symbol);
        contractItem.setExpiry(expiry);
        contractItem.setStrike(strike);
        contractItem.setRight(right);
        return contractItem;
    }

    public static ContractItem buildWarrantContract(String symbol, String expiry, Double strike, String right) {
        ContractItem contractItem = new ContractItem();
        contractItem.setSecType(SecType.WAR.name());
        contractItem.setSymbol(symbol);
        contractItem.setExpiry(expiry);
        contractItem.setStrike(strike);
        contractItem.setRight(right);
        contractItem.setLocalSymbol(symbol);
        contractItem.setCurrency(Currency.HKD.name());
        contractItem.setMarket(Market.HK.name());
        return contractItem;
    }

    public static ContractItem buildCbbcContract(String symbol, String expiry, Double strike, String right) {
        ContractItem contractItem = new ContractItem();
        contractItem.setSecType(SecType.IOPT.name());
        contractItem.setSymbol(symbol);
        contractItem.setExpiry(expiry);
        contractItem.setStrike(strike);
        contractItem.setRight(right);
        contractItem.setLocalSymbol(symbol);
        contractItem.setCurrency(Currency.HKD.name());
        contractItem.setMarket(Market.HK.name());
        return contractItem;
    }

    public static ContractItem buildFutureContract(String symbol, String currency, String exchange, String expiry, Double multiplier) {
        ContractItem contractItem = new ContractItem();
        contractItem.setSecType(SecType.FUT.name());
        contractItem.setSymbol(symbol);
        contractItem.setCurrency(currency);
        contractItem.setExchange(exchange);
        contractItem.setExpiry(expiry);
        contractItem.setMultiplier(multiplier);
        return contractItem;
    }

    public static ContractItem buildFutureContract(String symbol, String currency) {
        ContractItem contractItem = new ContractItem();
        contractItem.setSecType(SecType.FUT.name());
        contractItem.setSymbol(symbol);
        contractItem.setCurrency(currency);
        return contractItem;
    }

    public static ContractItem convertFromJson(String data) {
        if (data.startsWith("{\"items\":")) {
            List items = (List)JSON.parseObject((String)(data = data.substring("{\"items\":".length(), data.length() - 1)), (TypeReference)new TypeReference<List<ContractItem>>(){}, (Feature[])new Feature[0]);
            if (items == null || items.size() == 0) {
                return new ContractItem();
            }
            return (ContractItem)items.get(0);
        }
        return (ContractItem)JSON.parseObject((String)data, ContractItem.class);
    }

    public static List<ContractItem> convertFromJsonV2(String data) {
        if (data.startsWith("{\"items\":")) {
            data = data.substring("{\"items\":".length(), data.length() - 1);
            List items = (List)JSON.parseObject((String)data, (TypeReference)new TypeReference<List<ContractItem>>(){}, (Feature[])new Feature[0]);
            return items;
        }
        return null;
    }
}

