/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.https.domain.option.model;

import com.tigerbrokers.stock.openapi.client.TigerApiException;
import com.tigerbrokers.stock.openapi.client.https.domain.ApiModel;
import com.tigerbrokers.stock.openapi.client.struct.OptionSymbol;
import com.tigerbrokers.stock.openapi.client.struct.enums.TimeZoneId;
import com.tigerbrokers.stock.openapi.client.util.DateUtils;
import com.tigerbrokers.stock.openapi.client.util.SymbolUtil;
import java.util.Date;

public class OptionCommonModel
extends ApiModel {
    protected String symbol;
    protected String right;
    protected String strike;
    protected Long expiry;

    public OptionCommonModel() {
    }

    public OptionCommonModel(String identifier) throws TigerApiException {
        OptionSymbol optionSymbol = SymbolUtil.convertToOptionSymbolObject(identifier);
        this.setSymbol(optionSymbol.getSymbol());
        this.setRight(optionSymbol.getRight());
        this.setStrike(optionSymbol.getStrike());
        this.setExpiry(optionSymbol.getExpiry());
    }

    public OptionCommonModel(String symbol, String right, String strike, Long expiry) {
        this.symbol = symbol;
        this.right = right;
        this.strike = strike;
        this.expiry = expiry;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getRight() {
        return this.right;
    }

    public void setRight(String right) {
        this.right = right;
    }

    public String getStrike() {
        return this.strike;
    }

    public void setStrike(String strike) {
        this.strike = strike;
    }

    public Long getExpiry() {
        return this.expiry;
    }

    public void setExpiry(Long expiry) {
        this.expiry = expiry;
    }

    public void setExpiry(String expiry) {
        Date date = DateUtils.getZoneDate(expiry, TimeZoneId.NewYork);
        if (date != null) {
            this.expiry = date.getTime();
        }
    }

    public String toString() {
        return "OptionCommonModel{symbol='" + this.symbol + '\'' + ", right='" + this.right + '\'' + ", strike='" + this.strike + '\'' + ", expiry='" + this.expiry + '\'' + '}';
    }
}

