/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.config;

import com.tigerbrokers.stock.openapi.client.util.ApiLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class ClientConfig {
    private static final String PPRVATE_KEY_BEGIN = "-----BEGIN PRIVATE KEY-----";
    private static final String PRIVATE_KEY_END = "-----END PRIVATE KEY-----";
    public static final ClientConfig DEFAULT_CONFIG = new ClientConfig();
    public String label = "prod";
    public String serverUrl = "https://openapi.itiger.com/gateway";
    public String socketServerUrl = "wss://openapi.itiger.com:8887/stomp";
    public String tigerId = null;
    public String defaultAccount = null;
    public String privateKey = null;
    public String secretKey = null;

    public String readPrivateKey(String privateKeyFile) {
        String content = "";
        File file = new File(privateKeyFile);
        try (FileInputStream in = new FileInputStream(file);){
            int size = in.available();
            byte[] buffer = new byte[size];
            in.read(buffer);
            content = new String(buffer, "UTF-8");
            int start = 0;
            if (content.startsWith(PPRVATE_KEY_BEGIN)) {
                start = PPRVATE_KEY_BEGIN.length();
                while (content.charAt(start) == '\n' || content.charAt(start) == '\r') {
                    ++start;
                }
            }
            int end = content.length();
            int endIndex = content.indexOf(PRIVATE_KEY_END);
            if (endIndex > 0) {
                end = endIndex;
            }
            StringBuilder builder = new StringBuilder();
            for (int i = start; i < end; ++i) {
                if (content.charAt(i) == '\n' || content.charAt(i) == '\r') continue;
                builder.append(content.charAt(i));
            }
            content = builder.toString();
        }
        catch (IOException e) {
            ApiLogger.error("read file fail:" + privateKeyFile, e);
        }
        return content;
    }
}

