/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.util;

import com.tigerbrokers.stock.openapi.client.struct.OptionFundamentals;
import java.text.NumberFormat;

class OptionResult {
    OptionIndex index;
    double timeValue;
    double premiumRate;
    double profitRate;
    double volatility;
    double leverage;
    double insideValue;

    OptionResult() {
    }

    public OptionIndex getIndex() {
        return this.index;
    }

    public void setIndex(OptionIndex index) {
        this.index = index;
    }

    public double getTimeValue() {
        return this.timeValue;
    }

    public void setTimeValue(double timeValue) {
        this.timeValue = timeValue;
    }

    public double getPremiumRate() {
        return this.premiumRate;
    }

    public void setPremiumRate(double premiumRate) {
        this.premiumRate = premiumRate;
    }

    public double getProfitRate() {
        return this.profitRate;
    }

    public void setProfitRate(double profitRate) {
        this.profitRate = profitRate;
    }

    public double getVolatility() {
        return this.volatility;
    }

    public void setVolatility(double volatility) {
        this.volatility = volatility;
    }

    public double getLeverage() {
        return this.leverage;
    }

    public void setLeverage(double leverage) {
        this.leverage = leverage;
    }

    public double getInsideValue() {
        return this.insideValue;
    }

    public void setInsideValue(double insideValue) {
        this.insideValue = insideValue;
    }

    public String getTimeValueString() {
        return OptionResult.formatDoubleString(this.timeValue, 2);
    }

    public String getPremiumRateString() {
        return OptionResult.doubleToPercentageString(this.premiumRate, 2);
    }

    public String getProfitRateString() {
        return OptionResult.doubleToPercentageString(this.profitRate, 2);
    }

    public String getVolatilityString() {
        return OptionResult.doubleToPercentageString(this.volatility, 2);
    }

    public String getLeverageString() {
        return OptionResult.formatDoubleString(this.leverage, 2);
    }

    public String getInsideValueString() {
        return OptionResult.formatDoubleString(this.insideValue, 2);
    }

    private static String doubleToPercentageString(double src, int fractionDigits) {
        NumberFormat nf = NumberFormat.getPercentInstance();
        nf.setMinimumFractionDigits(fractionDigits);
        nf.setMaximumFractionDigits(fractionDigits);
        String res = nf.format(src);
        return res;
    }

    private static String formatDoubleString(double src, int fractionDigits) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMinimumFractionDigits(fractionDigits);
        nf.setMaximumFractionDigits(fractionDigits);
        String res = nf.format(src);
        return res;
    }

    public OptionFundamentals toOptionFundamentals(int openInterest, String volatility) {
        OptionFundamentals optionFundamentals = new OptionFundamentals();
        optionFundamentals.setPremiumRate(this.getPremiumRateString());
        optionFundamentals.setOpenInterest(openInterest + "");
        optionFundamentals.setVolatility(this.getVolatilityString());
        optionFundamentals.setHistoryVolatility(volatility);
        optionFundamentals.setDelta(this.getIndex().getDeltaString());
        optionFundamentals.setTheta(this.getIndex().getThetaString());
        optionFundamentals.setGamma(this.getIndex().getGammaString());
        optionFundamentals.setVega(this.getIndex().getVegaString());
        optionFundamentals.setTimeValue(this.getTimeValueString());
        optionFundamentals.setInsideValue(this.getInsideValueString());
        optionFundamentals.setLeverage(this.getLeverageString());
        optionFundamentals.setProfitRate(this.getProfitRateString());
        return optionFundamentals;
    }

    static class OptionIndex {
        double Delta;
        double Gamma;
        double Theta;
        double Vega;
        double Rho;

        public OptionIndex(double delta, double gamma, double theta, double vega, double rho) {
            this.Delta = delta;
            this.Gamma = gamma;
            this.Theta = theta;
            this.Vega = vega;
            this.Rho = rho;
        }

        public String getDeltaString() {
            return OptionResult.formatDoubleString(this.Delta, 3);
        }

        public String getGammaString() {
            return OptionResult.formatDoubleString(this.Gamma, 3);
        }

        public String getThetaString() {
            return OptionResult.formatDoubleString(this.Theta, 3);
        }

        public String getVegaString() {
            return OptionResult.formatDoubleString(this.Vega, 3);
        }

        public String getRhoString() {
            return OptionResult.formatDoubleString(this.Rho, 3);
        }

        public double getDelta() {
            return this.Delta;
        }

        public void setDelta(double delta) {
            this.Delta = delta;
        }

        public double getGamma() {
            return this.Gamma;
        }

        public void setGamma(double gamma) {
            this.Gamma = gamma;
        }

        public double getTheta() {
            return this.Theta;
        }

        public void setTheta(double theta) {
            this.Theta = theta;
        }

        public double getVega() {
            return this.Vega;
        }

        public void setVega(double vega) {
            this.Vega = vega;
        }

        public double getRho() {
            return this.Rho;
        }

        public void setRho(double rho) {
            this.Rho = rho;
        }
    }
}

