/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.util;

import com.tigerbrokers.stock.openapi.client.util.ApiLogger;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpUtils {
    public static final int CONNECT_TIMEOUT = 5000;
    public static final int SOCKET_TIMEOUT = 5000;
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static ConnectionPool connectionPool = new ConnectionPool(5, 60L, TimeUnit.SECONDS);
    public static OkHttpClient client = new OkHttpClient.Builder().connectTimeout(5000L, TimeUnit.MILLISECONDS).readTimeout(5000L, TimeUnit.MILLISECONDS).connectionPool(connectionPool).retryOnConnectionFailure(true).build();

    public static String post(String url, String json) throws Exception {
        if (url == null || json == null) {
            throw new RuntimeException("request url or json param cannot be null");
        }
        try {
            RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
            Request request = new Request.Builder().url(url).post(body).build();
            Response response = client.newCall(request).execute();
            if (response == null) {
                ApiLogger.error("HttpUtils response is null");
                throw new RuntimeException("http response is null");
            }
            if (response.body() == null) {
                ApiLogger.error("HttpUtils response body is null");
                throw new RuntimeException("http response body is null");
            }
            return response.body().string();
        }
        catch (IOException e) {
            ApiLogger.error("HttpUtils execute io exception:{}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
        catch (Exception e) {
            ApiLogger.error("HttpUtils execute exception:{}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
    }
}

