/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.util;

import com.tigerbrokers.stock.openapi.client.util.ApiLogger;
import com.tigerbrokers.stock.openapi.client.util.StringUtils;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslProvider;
import java.lang.reflect.Field;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.Set;

public class NetworkUtil {
    private static final String GET_DEVICE_ERROR = "Please check if the network connection is disconnected";
    private static final int MAC_ARRAY_LENGTH = 6;
    private static final int MAC_LENGTH = 17;

    private NetworkUtil() {
    }

    public static String getDeviceId() {
        InetAddress inetAddress = null;
        try {
            inetAddress = NetworkUtil.getLocalHostLANAddress();
        }
        catch (Throwable th) {
            ApiLogger.error("getLocalHostLANAddress failed. {}, {}", (Object)th.getMessage(), (Object)GET_DEVICE_ERROR);
        }
        return NetworkUtil.getMacFromInetAddress(inetAddress);
    }

    public static String getMacFromInetAddress(InetAddress inetAddress) {
        byte[] mac = null;
        if (inetAddress != null) {
            try {
                mac = NetworkInterface.getByInetAddress(inetAddress).getHardwareAddress();
            }
            catch (Throwable th) {
                ApiLogger.info("getHardwareAddress failed. {}", th.getMessage());
            }
        }
        if (mac == null || mac.length != 6) {
            String[] items;
            String ip;
            if (inetAddress != null && inetAddress instanceof Inet6Address) {
                ip = inetAddress.getHostAddress();
                items = ip.split("\\:");
                StringBuilder builder = new StringBuilder();
                for (String item : items) {
                    if (item == null || item.length() == 0 || "0".equals(item)) continue;
                    if (item.length() == 3 || item.length() == 1) {
                        item = "0" + item;
                    }
                    if (item.length() == 4) {
                        builder.append(item, 0, 2).append(':');
                        builder.append(item, 2, 4).append(':');
                        continue;
                    }
                    if (item.length() != 2) continue;
                    builder.append(item, 0, 2).append(':');
                }
                if (builder.length() >= 17) {
                    return builder.substring(0, 17);
                }
            }
            mac = new byte[6];
            if (inetAddress != null && inetAddress instanceof Inet4Address) {
                ip = inetAddress.getHostAddress();
                items = ip.split("\\.");
                for (int i = 0; i < 6; ++i) {
                    mac[i] = (byte)StringUtils.toInt(items[i % items.length], 0);
                }
            } else {
                Random random = new Random(System.currentTimeMillis());
                for (int i = 0; i < 6; ++i) {
                    mac[i] = (byte)random.nextInt(255);
                }
            }
        }
        StringBuilder deviceId = new StringBuilder();
        for (int i = 0; i < mac.length; ++i) {
            String str;
            if (i != 0) {
                deviceId.append(":");
            }
            if ((str = Integer.toHexString(mac[i] & 0xFF)).length() == 1) {
                deviceId.append(0);
            }
            deviceId.append(str);
        }
        return deviceId.toString();
    }

    private static InetAddress getLocalHostLANAddress() throws UnknownHostException {
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                if (networkInterface.isLoopback() || networkInterface.isVirtual() || networkInterface.isPointToPoint() || !networkInterface.isUp()) continue;
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    if (inetAddress.isSiteLocalAddress()) {
                        return inetAddress;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddress;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return jdkSuppliedAddress;
        }
        catch (Exception e) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address: " + e);
            unknownHostException.initCause(e);
            throw unknownHostException;
        }
    }

    public static String[] getOpenSslSupportedProtocolsSet(String[] serverSupportedProtocols, SslProvider sslProvider) {
        if (serverSupportedProtocols == null || serverSupportedProtocols.length == 0) {
            ApiLogger.error("Server Supported protocols (OpenSSL) is empty. serverSupportedProtocols:{}", serverSupportedProtocols);
            return serverSupportedProtocols;
        }
        if (sslProvider != SslProvider.OPENSSL || !OpenSsl.isAvailable()) {
            String[] supportedProtocols = new String[serverSupportedProtocols.length];
            System.arraycopy(serverSupportedProtocols, 0, supportedProtocols, 0, serverSupportedProtocols.length);
            return supportedProtocols;
        }
        Set localSupportedProtocols = Collections.emptySet();
        try {
            Field supportedProtocolsSetField = OpenSsl.class.getDeclaredField("SUPPORTED_PROTOCOLS_SET");
            if (supportedProtocolsSetField != null) {
                supportedProtocolsSetField.setAccessible(true);
                localSupportedProtocols = (Set)supportedProtocolsSetField.get(OpenSsl.class);
            }
        }
        catch (Throwable th) {
            ApiLogger.error("getOpenSslSupportedProtocolsSet exception:{}", (Object)th.getMessage(), (Object)th);
        }
        if (localSupportedProtocols.isEmpty()) {
            ApiLogger.error("Local Supported protocols (OpenSSL): {}, is empty", localSupportedProtocols);
            return null;
        }
        ApiLogger.info("Local Supported protocols (OpenSSL): {}", localSupportedProtocols);
        LinkedHashSet<String> supportedProtocols = new LinkedHashSet<String>();
        for (String protocol : serverSupportedProtocols) {
            if (!localSupportedProtocols.contains(protocol)) continue;
            supportedProtocols.add(protocol);
        }
        return supportedProtocols.toArray(new String[supportedProtocols.size()]);
    }
}

