/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.config;

import com.tigerbrokers.stock.openapi.client.struct.enums.Env;
import com.tigerbrokers.stock.openapi.client.struct.enums.License;
import com.tigerbrokers.stock.openapi.client.struct.enums.Protocol;
import com.tigerbrokers.stock.openapi.client.util.ApiLogger;
import io.netty.handler.ssl.SslProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class ClientConfig {
    private static final String PPRVATE_KEY_BEGIN = "-----BEGIN PRIVATE KEY-----";
    private static final String PRIVATE_KEY_END = "-----END PRIVATE KEY-----";
    private static final Protocol DEFAULT_PROTOCOL = Protocol.STOMP;
    private static final Env DEFAULT_ENV = Env.PROD;
    private static final License DEFAULT_LICENSE = License.TBNZ;
    private static final SslProvider DEFAULT_SSLPROVIDER = SslProvider.OPENSSL;
    public static final ClientConfig DEFAULT_CONFIG = new ClientConfig();
    private Protocol subscribeProtocol = DEFAULT_PROTOCOL;
    private Env env = DEFAULT_ENV;
    private License license = DEFAULT_LICENSE;
    private SslProvider sslProvider = DEFAULT_SSLPROVIDER;
    public String serverUrl;
    public String socketServerUrl;
    public String tigerId = null;
    public String defaultAccount = null;
    public String privateKey = null;
    public String secretKey = null;

    public Protocol getSubscribeProtocol() {
        return this.subscribeProtocol;
    }

    public void setSubscribeProtocol(Protocol subscribeProtocol) {
        if (subscribeProtocol == null || subscribeProtocol == Protocol.HTTP) {
            return;
        }
        this.subscribeProtocol = subscribeProtocol;
    }

    public Env getEnv() {
        return this.env;
    }

    public void setEnv(Env env) {
        if (env == null) {
            return;
        }
        this.env = env;
    }

    public License getLicense() {
        return this.license;
    }

    public void setLicense(License license) {
        if (license == null) {
            return;
        }
        this.license = license;
    }

    public SslProvider getSslProvider() {
        return this.sslProvider;
    }

    public void setSslProvider(SslProvider sslProvider) {
        this.sslProvider = sslProvider;
    }

    public String readPrivateKey(String privateKeyFile) {
        String content = "";
        File file = new File(privateKeyFile);
        try (FileInputStream in = new FileInputStream(file);){
            int size = in.available();
            byte[] buffer = new byte[size];
            in.read(buffer);
            content = new String(buffer, "UTF-8");
            int start = 0;
            if (content.startsWith(PPRVATE_KEY_BEGIN)) {
                start = PPRVATE_KEY_BEGIN.length();
                while (content.charAt(start) == '\n' || content.charAt(start) == '\r') {
                    ++start;
                }
            }
            int end = content.length();
            int endIndex = content.indexOf(PRIVATE_KEY_END);
            if (endIndex > 0) {
                end = endIndex;
            }
            StringBuilder builder = new StringBuilder();
            for (int i = start; i < end; ++i) {
                if (content.charAt(i) == '\n' || content.charAt(i) == '\r') continue;
                builder.append(content.charAt(i));
            }
            content = builder.toString();
        }
        catch (IOException e) {
            ApiLogger.error("read file fail:" + privateKeyFile, e);
        }
        return content;
    }
}

