/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.util;

import com.tigerbrokers.stock.openapi.client.struct.enums.QuoteSubject;
import com.tigerbrokers.stock.openapi.client.struct.enums.Subject;
import com.tigerbrokers.stock.openapi.client.util.builder.StompHeaderBuilder;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.stomp.DefaultStompFrame;
import io.netty.handler.codec.stomp.StompCommand;
import io.netty.handler.codec.stomp.StompFrame;
import io.netty.handler.codec.stomp.StompHeaders;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class StompMessageUtil {
    private static AtomicInteger increment = new AtomicInteger(0);

    public static StompFrame buildConnectMessage(String login, String passcode, String version) {
        DefaultStompFrame stompFrame = new DefaultStompFrame(StompCommand.CONNECT);
        stompFrame.headers().set((Headers)StompHeaderBuilder.instance().version(version).sdkVersion().host().login(login).passcode(passcode).build());
        return stompFrame;
    }

    public static StompFrame buildConnectMessage(String login, String passcode, String version, int sendInterval, int receiveInterval) {
        if (sendInterval < 0 || receiveInterval < 0) {
            throw new RuntimeException("sendInterval < 0 or receiveInterval < 0");
        }
        DefaultStompFrame stompFrame = new DefaultStompFrame(StompCommand.CONNECT);
        stompFrame.headers().set((Headers)StompHeaderBuilder.instance().version(version).sdkVersion().host().login(login).passcode(passcode).heartBeat(sendInterval, receiveInterval).build());
        return stompFrame;
    }

    public static StompFrame buildSendMessage(int reqType, String message) {
        if (reqType <= 0) {
            throw new RuntimeException("reqType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int id = increment.addAndGet(1);
        DefaultStompFrame stompFrame = message != null ? new DefaultStompFrame(StompCommand.SEND, Unpooled.wrappedBuffer((byte[])message.getBytes(Charset.defaultCharset()))) : new DefaultStompFrame(StompCommand.SEND);
        StompHeaders headers = StompHeaderBuilder.instance().id(id).host().reqType(reqType).build();
        stompFrame.headers().set((Headers)headers);
        return stompFrame;
    }

    public static StompFrame buildCommonSendMessage(String message) {
        int id = increment.addAndGet(1);
        DefaultStompFrame stompFrame = message != null ? new DefaultStompFrame(StompCommand.SEND, Unpooled.wrappedBuffer((byte[])message.getBytes(Charset.defaultCharset()))) : new DefaultStompFrame(StompCommand.SEND);
        StompHeaders headers = StompHeaderBuilder.instance().id(id).host().build();
        stompFrame.headers().set((Headers)headers);
        return stompFrame;
    }

    public static StompFrame buildSubscribeMessage(Subject subject) {
        DefaultStompFrame stompFrame = new DefaultStompFrame(StompCommand.SUBSCRIBE);
        int id = increment.addAndGet(1);
        StompHeaders headers = StompHeaderBuilder.instance().id(id).host().subject(subject).build();
        stompFrame.headers().set((Headers)headers);
        return stompFrame;
    }

    public static StompFrame buildSubscribeMessage(String account, Subject subject, Set<String> focusKeys) {
        DefaultStompFrame stompFrame = new DefaultStompFrame(StompCommand.SUBSCRIBE);
        int id = increment.addAndGet(1);
        StompHeaders headers = StompHeaderBuilder.instance().id(id).account(account).host().subject(subject).focusKeys(focusKeys).build();
        stompFrame.headers().set((Headers)headers);
        return stompFrame;
    }

    public static StompFrame buildSubscribeMessage(Set<String> symbols, QuoteSubject subject) {
        DefaultStompFrame stompFrame = new DefaultStompFrame(StompCommand.SUBSCRIBE);
        int id = increment.addAndGet(1);
        StompHeaders headers = StompHeaderBuilder.instance().id(id).host().subject(subject.name()).symbols(symbols).build();
        stompFrame.headers().set((Headers)headers);
        return stompFrame;
    }

    public static StompFrame buildSubscribeMessage(Set<String> symbols, QuoteSubject subject, Set<String> focusKeys) {
        DefaultStompFrame stompFrame = new DefaultStompFrame(StompCommand.SUBSCRIBE);
        int id = increment.addAndGet(1);
        StompHeaders headers = StompHeaderBuilder.instance().id(id).host().subject(subject.name()).symbols(symbols).focusKeys(focusKeys).build();
        stompFrame.headers().set((Headers)headers);
        return stompFrame;
    }

    public static StompFrame buildSubscribeMessage(Subject subject, Set<String> focusKeys) {
        DefaultStompFrame stompFrame = new DefaultStompFrame(StompCommand.SUBSCRIBE);
        int id = increment.addAndGet(1);
        StompHeaders headers = StompHeaderBuilder.instance().id(id).host().subject(subject).focusKeys(focusKeys).build();
        stompFrame.headers().set((Headers)headers);
        return stompFrame;
    }

    public static StompFrame buildUnSubscribeMessage(Subject subject) {
        DefaultStompFrame stompFrame = new DefaultStompFrame(StompCommand.UNSUBSCRIBE);
        int id = increment.addAndGet(1);
        StompHeaders headers = StompHeaderBuilder.instance().id(id).host().subject(subject).build();
        stompFrame.headers().set((Headers)headers);
        return stompFrame;
    }

    public static StompFrame buildUnSubscribeMessage(Set<String> symbols, QuoteSubject subject) {
        DefaultStompFrame stompFrame = new DefaultStompFrame(StompCommand.UNSUBSCRIBE);
        int id = increment.addAndGet(1);
        StompHeaders headers = StompHeaderBuilder.instance().id(id).host().subject(subject.name()).symbols(symbols).build();
        stompFrame.headers().set((Headers)headers);
        return stompFrame;
    }

    public static StompFrame buildDisconnectMessage(String login) {
        DefaultStompFrame stompFrame = new DefaultStompFrame(StompCommand.DISCONNECT);
        StompHeaders headers = StompHeaderBuilder.instance().login(login).host().build();
        stompFrame.headers().set((Headers)headers);
        return stompFrame;
    }
}

