/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.https.request.trade;

import com.tigerbrokers.stock.openapi.client.config.ClientConfig;
import com.tigerbrokers.stock.openapi.client.https.domain.trade.model.PrimeAnalyticsAssetModel;
import com.tigerbrokers.stock.openapi.client.https.request.TigerCommonRequest;
import com.tigerbrokers.stock.openapi.client.https.request.TigerRequest;
import com.tigerbrokers.stock.openapi.client.https.response.trade.PrimeAnalyticsAssetResponse;
import com.tigerbrokers.stock.openapi.client.struct.enums.Currency;
import com.tigerbrokers.stock.openapi.client.struct.enums.SegmentType;
import com.tigerbrokers.stock.openapi.client.struct.enums.TimeZoneId;
import com.tigerbrokers.stock.openapi.client.util.DateUtils;

public class PrimeAnalyticsAssetRequest
extends TigerCommonRequest
implements TigerRequest<PrimeAnalyticsAssetResponse> {
    public PrimeAnalyticsAssetRequest() {
        this.setApiVersion("1.0");
        this.setApiMethodName("analytics_asset");
    }

    public static PrimeAnalyticsAssetRequest buildPrimeAnalyticsAssetRequest() {
        return PrimeAnalyticsAssetRequest.buildPrimeAnalyticsAssetRequest(ClientConfig.DEFAULT_CONFIG.defaultAccount);
    }

    public static PrimeAnalyticsAssetRequest buildPrimeAnalyticsAssetRequest(String account) {
        return PrimeAnalyticsAssetRequest.buildPrimeAnalyticsAssetRequest(account, ClientConfig.DEFAULT_CONFIG.secretKey);
    }

    public static PrimeAnalyticsAssetRequest buildPrimeAnalyticsAssetRequest(String account, String secretKey) {
        PrimeAnalyticsAssetRequest primeAssetRequest = new PrimeAnalyticsAssetRequest();
        primeAssetRequest.setApiModel(new PrimeAnalyticsAssetModel(account, secretKey));
        return primeAssetRequest;
    }

    public PrimeAnalyticsAssetRequest startDate(String startDate) {
        this.getPrimeAnalyticsAssetModel().setStartDate(startDate);
        return this;
    }

    public PrimeAnalyticsAssetRequest startDate(Long startDate) {
        return this.startDate(startDate, ClientConfig.DEFAULT_CONFIG.getDefaultTimeZone());
    }

    public PrimeAnalyticsAssetRequest startDate(Long startDate, TimeZoneId zoneId) {
        if (startDate != null) {
            this.getPrimeAnalyticsAssetModel().setStartDate(DateUtils.printDate(startDate, zoneId));
        }
        return this;
    }

    public PrimeAnalyticsAssetRequest endDate(String endDate) {
        this.getPrimeAnalyticsAssetModel().setEndDate(endDate);
        return this;
    }

    public PrimeAnalyticsAssetRequest endDate(Long endDate) {
        return this.endDate(endDate, ClientConfig.DEFAULT_CONFIG.getDefaultTimeZone());
    }

    public PrimeAnalyticsAssetRequest endDate(Long endDate, TimeZoneId zoneId) {
        if (endDate != null) {
            this.getPrimeAnalyticsAssetModel().setEndDate(DateUtils.printDate(endDate, zoneId));
        }
        return this;
    }

    public PrimeAnalyticsAssetRequest segType(SegmentType segmentType) {
        this.getPrimeAnalyticsAssetModel().setSegType(segmentType);
        return this;
    }

    public PrimeAnalyticsAssetRequest currency(Currency currency) {
        this.getPrimeAnalyticsAssetModel().setCurrency(currency);
        return this;
    }

    public PrimeAnalyticsAssetRequest subAccount(String subAccount) {
        this.getPrimeAnalyticsAssetModel().setSubAccount(subAccount);
        return this;
    }

    private PrimeAnalyticsAssetModel getPrimeAnalyticsAssetModel() {
        if (this.apiModel == null) {
            this.apiModel = new PrimeAnalyticsAssetModel(ClientConfig.DEFAULT_CONFIG.defaultAccount, ClientConfig.DEFAULT_CONFIG.secretKey);
        }
        return (PrimeAnalyticsAssetModel)this.apiModel;
    }

    @Override
    public Class<PrimeAnalyticsAssetResponse> getResponseClass() {
        return PrimeAnalyticsAssetResponse.class;
    }
}

