/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.websocket;

import com.tigerbrokers.stock.openapi.client.socket.ApiAuthentication;
import com.tigerbrokers.stock.openapi.client.socket.ApiCallbackDecoder;
import com.tigerbrokers.stock.openapi.client.socket.ApiComposeCallback;
import com.tigerbrokers.stock.openapi.client.util.ApiCallbackDecoderUtils;
import com.tigerbrokers.stock.openapi.client.util.ApiLogger;
import com.tigerbrokers.stock.openapi.client.util.StompMessageUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.stomp.StompFrame;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;

@ChannelHandler.Sharable
public class WebSocketHandshakerHandler
extends SimpleChannelInboundHandler<Object> {
    private ApiAuthentication authentication;
    private ApiCallbackDecoder decoder;
    private WebSocketClientHandshaker handshaker;
    private int clientSendInterval = 0;
    private int clientReceiveInterval = 0;

    public WebSocketHandshakerHandler(ApiAuthentication authentication, ApiComposeCallback callback) {
        this.authentication = authentication;
        this.decoder = new ApiCallbackDecoder(callback);
    }

    public WebSocketHandshakerHandler(ApiAuthentication authentication, ApiComposeCallback callback, int sendInterval, int receiveInterval) {
        this.authentication = authentication;
        this.decoder = new ApiCallbackDecoder(callback);
        this.clientSendInterval = sendInterval;
        this.clientReceiveInterval = receiveInterval;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
    }

    public void setHandshaker(WebSocketClientHandshaker handshaker) {
        this.handshaker = handshaker;
    }

    public WebSocketClientHandshaker getHandshaker() {
        return this.handshaker;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ApiLogger.info("netty channel inactive! channel:{}", ctx.channel());
        super.channelInactive(ctx);
        ctx.close();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ApiLogger.error("handler exception caught:", cause);
        ctx.close();
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        ApiLogger.info("WebSocketHandshakerHandler channelRead0 isHandshakeComplete:{}", this.handshaker.isHandshakeComplete());
        final Channel ch = ctx.channel();
        if (!this.handshaker.isHandshakeComplete()) {
            FullHttpResponse response = (FullHttpResponse)msg;
            this.handshaker.finishHandshake(ch, response);
            StompFrame connectFrame = 0 == this.clientReceiveInterval && 0 == this.clientSendInterval ? StompMessageUtil.buildConnectMessage(this.authentication.getTigerId(), this.authentication.getSign(), this.authentication.getVersion()) : StompMessageUtil.buildConnectMessage(this.authentication.getTigerId(), this.authentication.getSign(), this.authentication.getVersion(), this.clientSendInterval == 0 ? 0 : this.clientSendInterval + 1000, this.clientReceiveInterval == 0 ? 0 : this.clientReceiveInterval - 1000);
            ApiLogger.info("WebSocket Client connected. channel:{}, response headers[sec-websocket-extensions]:{}, then preparing to send connect token frame:{}", ch.id().asShortText(), response.headers(), connectFrame);
            ctx.writeAndFlush((Object)connectFrame).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) {
                    if (future.isSuccess()) {
                        ApiLogger.info("WebSocket Client send connect token frame successfully. channel:{}", ch.id().asShortText());
                    } else {
                        ApiLogger.error("WebSocket Client failed to send connect token. channel:{}, isDone:{}, cause:{}", ch.id().asShortText(), future.isDone(), future.cause().getMessage());
                    }
                }
            });
        } else {
            if (msg instanceof FullHttpResponse) {
                FullHttpResponse response = (FullHttpResponse)msg;
                throw new IllegalStateException("Unexpected FullHttpResponse (getStatus=" + response.status() + ", content=" + response.content().toString(CharsetUtil.UTF_8) + ')');
            }
            StompFrame stompFrame = (StompFrame)msg;
            ApiLogger.debug("received stop frame from server: {}", stompFrame);
            try {
                ApiCallbackDecoderUtils.executor(ctx, stompFrame, this.decoder);
            }
            catch (Throwable th) {
                ApiLogger.error("api callback fail. stompFrame:{}", (Object)stompFrame, (Object)th);
            }
        }
    }
}

