/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.https.client;

import com.alibaba.fastjson.JSONObject;
import com.tigerbrokers.stock.openapi.client.config.ClientConfig;
import com.tigerbrokers.stock.openapi.client.https.client.DefaultRefreshTokenCallback;
import com.tigerbrokers.stock.openapi.client.https.client.RefreshTokenCallback;
import com.tigerbrokers.stock.openapi.client.https.client.TigerHttpClient;
import com.tigerbrokers.stock.openapi.client.https.request.user.UserTokenRefreshRequest;
import com.tigerbrokers.stock.openapi.client.https.response.user.UserTokenResponse;
import com.tigerbrokers.stock.openapi.client.util.ApiLogger;
import com.tigerbrokers.stock.openapi.client.util.DateUtils;
import com.tigerbrokers.stock.openapi.client.util.FileUtil;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class TokenManager {
    private static final TokenManager tokenManager = new TokenManager();
    private final long REFRESH_INTERVAL_MS = TimeUnit.DAYS.toMillis(1L);
    private ScheduledThreadPoolExecutor executorService;
    private ClientConfig clientConfig;
    private final List<RefreshTokenCallback> callbackList = new ArrayList<RefreshTokenCallback>();
    private final RefreshTokenCallback defaultCallback = new DefaultRefreshTokenCallback();

    private TokenManager() {
    }

    public static TokenManager getInstance() {
        return tokenManager;
    }

    public void destroy() {
        if (this.executorService != null && !this.executorService.isShutdown()) {
            this.executorService.shutdown();
        }
        this.callbackList.clear();
    }

    public void init(ClientConfig config) {
        if (config == null || !config.isAutoRefreshToken) {
            return;
        }
        this.clientConfig = config;
        boolean result = FileUtil.loadTokenFile(this.clientConfig);
        long tokenCreateTime = 0L;
        try {
            tokenCreateTime = FileUtil.getCreateTime(this.clientConfig.token);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.register(this.defaultCallback);
        if (result && tokenCreateTime > 0L) {
            this.executorService = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = Executors.defaultThreadFactory().newThread(r);
                    t.setDaemon(true);
                    return t;
                }
            });
            long initialDelay = tokenCreateTime + this.REFRESH_INTERVAL_MS - System.currentTimeMillis();
            initialDelay = initialDelay < 0L ? 0L : initialDelay;
            this.executorService.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    TokenManager.this.refreshToken();
                }
            }, initialDelay, this.REFRESH_INTERVAL_MS, TimeUnit.MILLISECONDS);
            ApiLogger.info("init refresh token task success");
        }
    }

    public void register(RefreshTokenCallback callback) {
        if (callback != null && !this.callbackList.contains(callback)) {
            this.callbackList.add(callback);
        }
    }

    public void unregister(RefreshTokenCallback callback) {
        if (callback != null) {
            this.callbackList.remove(callback);
        }
    }

    public List<RefreshTokenCallback> getCallbackList() {
        return this.callbackList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshToken() {
        long tokenCreateTime = 0L;
        try {
            tokenCreateTime = FileUtil.getCreateTime(this.clientConfig.token);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (tokenCreateTime + this.REFRESH_INTERVAL_MS - System.currentTimeMillis() > 0L) {
            ApiLogger.info("refreshToken last update time:{}, ignore", DateUtils.printDateTime(tokenCreateTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"), this.clientConfig.timeZone));
            return;
        }
        UserTokenRefreshRequest request = new UserTokenRefreshRequest();
        int count = 5;
        String oldToken = this.clientConfig.token;
        do {
            try {
                UserTokenResponse response = TigerHttpClient.getInstance().execute(request);
                if (response.isSuccess()) {
                    ApiLogger.info("refreshToken success. return:" + JSONObject.toJSONString((Object)response.getUserToken()));
                    for (RefreshTokenCallback callback : this.callbackList) {
                        callback.tokenChange(this.clientConfig, oldToken, response.getUserToken());
                    }
                    break;
                }
                TimeUnit.SECONDS.sleep(5L);
            }
            catch (Throwable th) {
                ApiLogger.warn("refreshToken fail. " + th.getMessage(), new Object[0]);
            }
            finally {
                --count;
            }
        } while (count > 0);
    }
}

