/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.struct.enums;

import java.util.ArrayList;
import java.util.List;

public enum QuoteKeyType {
    TRADE("TRADE", "open", "high", "low", "preClose", "volume", "latestPrice", "latestTime"),
    QUOTE("QUOTE", "askPrice", "askSize", "bidPrice", "bidSize"),
    TIMELINE("TIMELINE", "mi"),
    ALL("ALL", "open", "high", "low", "preClose", "volume", "latestPrice", "latestTime", "askPrice", "askSize", "bidPrice", "bidSize", "mi");

    private final String keyType;
    private final List<String> focusKeys;

    private QuoteKeyType(String keyType, String ... focusKey) {
        this.keyType = keyType;
        this.focusKeys = new ArrayList<String>();
        if (focusKey != null) {
            for (String key : focusKey) {
                this.focusKeys.add(key);
            }
        }
    }

    public String getKeyType() {
        return this.keyType;
    }

    public List<String> getFocusKeys() {
        return this.focusKeys;
    }
}

