/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.socket;

import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.Message;
import com.tigerbrokers.stock.openapi.client.socket.ApiComposeCallback;
import com.tigerbrokers.stock.openapi.client.socket.data.pb.PushData;
import com.tigerbrokers.stock.openapi.client.socket.data.pb.QuoteBBOData;
import com.tigerbrokers.stock.openapi.client.socket.data.pb.QuoteBasicData;
import com.tigerbrokers.stock.openapi.client.socket.data.pb.Response;
import com.tigerbrokers.stock.openapi.client.socket.data.pb.SocketCommon;
import com.tigerbrokers.stock.openapi.client.struct.SubscribedSymbol;
import com.tigerbrokers.stock.openapi.client.util.ApiLogger;
import com.tigerbrokers.stock.openapi.client.util.ProtoMessageUtil;
import com.tigerbrokers.stock.openapi.client.util.QuoteDataUtil;
import com.tigerbrokers.stock.openapi.client.util.StringUtils;
import com.tigerbrokers.stock.openapi.client.util.TradeTickUtil;

public class ApiCallbackDecoder {
    private ApiComposeCallback callback;

    public ApiCallbackDecoder(ApiComposeCallback callback) {
        this.callback = callback;
    }

    public synchronized void handle(Response msg) {
        int code = msg.getCode();
        switch (code) {
            case 111: {
                this.processGetSubscribedSymbols(msg);
                break;
            }
            case 112: {
                this.processSubscribeEnd(msg);
                break;
            }
            case 113: {
                this.processCancelSubscribeEnd(msg);
                break;
            }
            case 200: {
                this.processErrorEnd(msg);
                break;
            }
            default: {
                this.processSubscribeDataChange(msg);
            }
        }
    }

    public ApiComposeCallback getCallback() {
        return this.callback;
    }

    private void processSubscribeDataChange(Response msg) {
        PushData pushData = msg.getBody();
        if (pushData == null || pushData.getDataType() == null) {
            return;
        }
        QuoteBasicData basicData = null;
        QuoteBBOData bboData = null;
        SocketCommon.DataType dataType = pushData.getDataType();
        switch (dataType) {
            case Quote: {
                basicData = QuoteDataUtil.convertToBasicData(pushData.getQuoteData());
                if (null != basicData) {
                    this.callback.quoteChange(basicData);
                }
                if (null == (bboData = QuoteDataUtil.convertToAskBidData(pushData.getQuoteData()))) break;
                this.callback.quoteAskBidChange(bboData);
                break;
            }
            case Option: {
                basicData = QuoteDataUtil.convertToBasicData(pushData.getQuoteData());
                if (null != basicData) {
                    this.callback.optionChange(basicData);
                }
                if (null == (bboData = QuoteDataUtil.convertToAskBidData(pushData.getQuoteData()))) break;
                this.callback.optionAskBidChange(bboData);
                break;
            }
            case Future: {
                basicData = QuoteDataUtil.convertToBasicData(pushData.getQuoteData());
                if (null != basicData) {
                    this.callback.futureChange(basicData);
                }
                if (null == (bboData = QuoteDataUtil.convertToAskBidData(pushData.getQuoteData()))) break;
                this.callback.futureAskBidChange(bboData);
                break;
            }
            case TradeTick: {
                this.callback.tradeTickChange(TradeTickUtil.convert(pushData.getTradeTickData()));
                break;
            }
            case QuoteDepth: {
                this.callback.depthQuoteChange(pushData.getQuoteDepthData());
                break;
            }
            case Asset: {
                this.callback.assetChange(pushData.getAssetData());
                break;
            }
            case Position: {
                this.callback.positionChange(pushData.getPositionData());
                break;
            }
            case OrderStatus: {
                this.callback.orderStatusChange(pushData.getOrderStatusData());
                break;
            }
            case OrderTransaction: {
                this.callback.orderTransactionChange(pushData.getOrderTransactionData());
                break;
            }
            case StockTop: {
                this.callback.stockTopPush(pushData.getStockTopData());
                break;
            }
            case OptionTop: {
                this.callback.optionTopPush(pushData.getOptionTopData());
                break;
            }
            default: {
                ApiLogger.info("push data cannot be processed. {}", ProtoMessageUtil.toJson((Message)msg));
            }
        }
    }

    private void processGetSubscribedSymbols(Response msg) {
        String subscribedSymbol = msg.getMsg();
        this.callback.getSubscribedSymbolEnd((SubscribedSymbol)JSONObject.parseObject((String)subscribedSymbol, SubscribedSymbol.class));
    }

    private void processSubscribeEnd(Response msg) {
        SocketCommon.DataType dataType = msg.getBody() == null ? null : msg.getBody().getDataType();
        this.callback.subscribeEnd(msg.getId(), dataType == null ? null : dataType.name(), msg.getMsg());
    }

    private void processCancelSubscribeEnd(Response msg) {
        SocketCommon.DataType dataType = msg.getBody() == null ? null : msg.getBody().getDataType();
        this.callback.cancelSubscribeEnd(msg.getId(), dataType == null ? null : dataType.name(), msg.getMsg());
    }

    private void processErrorEnd(Response msg) {
        if (!StringUtils.isEmpty(msg.getMsg())) {
            this.callback.error(msg.getMsg());
        } else {
            this.callback.error("unknown error");
        }
    }

    public void processHeartBeat(String content) {
        this.callback.hearBeat(content);
    }

    public void serverHeartBeatTimeOut(String channelId) {
        this.callback.serverHeartBeatTimeOut(channelId);
    }
}

