/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.https.request.fund;

import com.tigerbrokers.stock.openapi.client.https.domain.fund.model.FundSymbolModel;
import com.tigerbrokers.stock.openapi.client.https.request.TigerCommonRequest;
import com.tigerbrokers.stock.openapi.client.https.request.TigerRequest;
import com.tigerbrokers.stock.openapi.client.https.response.fund.FundContractsResponse;
import com.tigerbrokers.stock.openapi.client.struct.enums.Language;
import com.tigerbrokers.stock.openapi.client.struct.enums.MethodName;
import java.util.List;

public class FundContractsRequest
extends TigerCommonRequest
implements TigerRequest<FundContractsResponse> {
    public FundContractsRequest() {
        this.setApiMethodName(MethodName.FUND_CONTRACTS);
    }

    public static FundContractsRequest newRequest(List<String> symbols) {
        return FundContractsRequest.newRequest(symbols, null);
    }

    public static FundContractsRequest newRequest(List<String> symbols, Language lang) {
        FundContractsRequest request = new FundContractsRequest();
        FundSymbolModel model = new FundSymbolModel(symbols, lang);
        request.setApiModel(model);
        return request;
    }

    @Override
    public FundSymbolModel getApiModel() {
        if (this.apiModel == null) {
            this.apiModel = new FundSymbolModel();
        }
        return (FundSymbolModel)this.apiModel;
    }

    public FundContractsRequest symbols(List<String> symbols) {
        this.getApiModel().setSymbols(symbols);
        return this;
    }

    public FundContractsRequest lang(Language lang) {
        this.getApiModel().setLang(lang);
        return this;
    }

    @Override
    public Class<FundContractsResponse> getResponseClass() {
        return FundContractsResponse.class;
    }
}

