/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.https.request.fund;

import com.tigerbrokers.stock.openapi.client.https.domain.fund.model.FundSymbolModel;
import com.tigerbrokers.stock.openapi.client.https.request.TigerCommonRequest;
import com.tigerbrokers.stock.openapi.client.https.request.TigerRequest;
import com.tigerbrokers.stock.openapi.client.https.response.fund.FundQuoteResponse;
import com.tigerbrokers.stock.openapi.client.struct.enums.Language;
import com.tigerbrokers.stock.openapi.client.struct.enums.MethodName;
import java.util.List;

public class FundQuoteRequest
extends TigerCommonRequest
implements TigerRequest<FundQuoteResponse> {
    public FundQuoteRequest() {
        this.setApiMethodName(MethodName.FUND_QUOTE);
    }

    public static FundQuoteRequest newRequest(List<String> symbols) {
        return FundQuoteRequest.newRequest(symbols, null);
    }

    public static FundQuoteRequest newRequest(List<String> symbols, Language lang) {
        FundQuoteRequest request = new FundQuoteRequest();
        FundSymbolModel model = new FundSymbolModel(symbols, lang);
        request.setApiModel(model);
        return request;
    }

    @Override
    public FundSymbolModel getApiModel() {
        if (this.apiModel == null) {
            this.apiModel = new FundSymbolModel();
        }
        return (FundSymbolModel)this.apiModel;
    }

    public FundQuoteRequest symbols(List<String> symbols) {
        this.getApiModel().setSymbols(symbols);
        return this;
    }

    public FundQuoteRequest lang(Language lang) {
        this.getApiModel().setLang(lang);
        return this;
    }

    @Override
    public Class<FundQuoteResponse> getResponseClass() {
        return FundQuoteResponse.class;
    }
}

