/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.https.request.fund;

import com.tigerbrokers.stock.openapi.client.https.domain.fund.model.FundQuoteHistoryModel;
import com.tigerbrokers.stock.openapi.client.https.request.TigerCommonRequest;
import com.tigerbrokers.stock.openapi.client.https.request.TigerRequest;
import com.tigerbrokers.stock.openapi.client.https.response.fund.FundHistoryQuoteResponse;
import com.tigerbrokers.stock.openapi.client.struct.enums.Language;
import com.tigerbrokers.stock.openapi.client.struct.enums.MethodName;
import com.tigerbrokers.stock.openapi.client.struct.enums.TimeZoneId;
import java.util.List;

public class FundHistoryQuoteRequest
extends TigerCommonRequest
implements TigerRequest<FundHistoryQuoteResponse> {
    public FundHistoryQuoteRequest() {
        this.setApiMethodName(MethodName.FUND_HISTORY_QUOTE);
    }

    public static FundHistoryQuoteRequest newRequest(List<String> symbols) {
        return FundHistoryQuoteRequest.newRequest(symbols, null, null);
    }

    public static FundHistoryQuoteRequest newRequest(List<String> symbols, Long beginTime, Long endTime) {
        FundHistoryQuoteRequest request = new FundHistoryQuoteRequest();
        FundQuoteHistoryModel model = new FundQuoteHistoryModel(symbols, beginTime, endTime);
        request.setApiModel(model);
        return request;
    }

    public static FundHistoryQuoteRequest newRequest(List<String> symbols, String beginTime, String endTime, TimeZoneId zoneId) {
        FundHistoryQuoteRequest request = new FundHistoryQuoteRequest();
        FundQuoteHistoryModel model = new FundQuoteHistoryModel(symbols, beginTime, endTime, zoneId);
        request.setApiModel(model);
        return request;
    }

    @Override
    public FundQuoteHistoryModel getApiModel() {
        if (this.apiModel == null) {
            this.apiModel = new FundQuoteHistoryModel(null);
        }
        return (FundQuoteHistoryModel)this.apiModel;
    }

    public FundHistoryQuoteRequest symbols(List<String> symbols) {
        this.getApiModel().setSymbols(symbols);
        return this;
    }

    public FundHistoryQuoteRequest beginTime(long beginTime) {
        this.getApiModel().setBeginTime(beginTime);
        return this;
    }

    public FundHistoryQuoteRequest endTime(long endTime) {
        this.getApiModel().setEndTime(endTime);
        return this;
    }

    public FundHistoryQuoteRequest limit(int limit) {
        this.getApiModel().setLimit(limit);
        return this;
    }

    public FundHistoryQuoteRequest lang(Language lang) {
        this.getApiModel().setLang(lang);
        return this;
    }

    @Override
    public Class<FundHistoryQuoteResponse> getResponseClass() {
        return FundHistoryQuoteResponse.class;
    }
}

