/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.util;

import com.tigerbrokers.stock.openapi.client.config.ClientConfig;
import com.tigerbrokers.stock.openapi.client.constant.TigerApiConstants;
import com.tigerbrokers.stock.openapi.client.struct.enums.Env;
import com.tigerbrokers.stock.openapi.client.struct.enums.License;
import com.tigerbrokers.stock.openapi.client.util.ApiLogger;
import com.tigerbrokers.stock.openapi.client.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ConfigFileUtil {
    private static final String PPRVATE_KEY_PREFIX = "KEY-----";
    private static final String PRIVATE_KEY_SUFFIX = "-----END";
    private static final String COMMENT_PREFIX = "#";
    private static final char EQUAL_CHAR = '=';
    private static final String UTF8_BOM = "\ufeff";
    private static final String CONFIG_FILE_PRIVATE_KEY = "private_key_pk8";
    private static final String CONFIG_FILE_TIGER_ID = "tiger_id";
    private static final String CONFIG_FILE_ACCOUNT = "account";
    private static final String CONFIG_FILE_LICENSE = "license";
    private static final String CONFIG_FILE_ENV = "env";
    public static final String TOKEN_FILE_TOKEN = "token";
    private static final Set<String> configFileKeys = new HashSet<String>();

    private ConfigFileUtil() {
    }

    public static boolean checkFile(String dir, String fileName, boolean writable) {
        if (StringUtils.isEmpty(dir)) {
            return false;
        }
        Path configPath = Paths.get(dir = dir.trim(), new String[0]);
        if (Files.notExists(configPath, new LinkOption[0]) || !Files.isDirectory(configPath, new LinkOption[0])) {
            ApiLogger.debug("config file directory[{}] is missing, ingore", dir);
            return false;
        }
        Path configFilePath = Paths.get(dir, fileName);
        if (Files.notExists(configFilePath, new LinkOption[0])) {
            ApiLogger.debug("config file[{}] is missing, ingore", configFilePath.toAbsolutePath().toString());
            return false;
        }
        if (!writable && !Files.isReadable(configFilePath)) {
            ApiLogger.warn("config file[{}] is unreadable", configFilePath.toAbsolutePath().toString());
            return false;
        }
        if (writable && !Files.isWritable(configFilePath)) {
            ApiLogger.warn("config file[{}] is unwritable", configFilePath.toAbsolutePath().toString());
            return false;
        }
        return true;
    }

    public static void loadConfigFile(ClientConfig clientConfig) {
        if (!ConfigFileUtil.checkFile(clientConfig.configFilePath, "tiger_openapi_config.properties", false)) {
            return;
        }
        Path configFilePath = Paths.get(clientConfig.configFilePath.trim(), "tiger_openapi_config.properties");
        Map<String, String> dataMap = ConfigFileUtil.readPropertiesFile(configFilePath, configFileKeys);
        for (Map.Entry<String, String> entry : dataMap.entrySet()) {
            switch (entry.getKey()) {
                case "private_key_pk8": {
                    clientConfig.privateKey = entry.getValue();
                    break;
                }
                case "tiger_id": {
                    clientConfig.tigerId = entry.getValue();
                    break;
                }
                case "account": {
                    clientConfig.defaultAccount = entry.getValue();
                    break;
                }
                case "license": {
                    License license = License.getLicense(entry.getValue());
                    if (null == license) break;
                    clientConfig.license = license;
                    break;
                }
                case "env": {
                    Env env = Env.getEnv(entry.getValue());
                    if (null == env) break;
                    clientConfig.setEnv(env);
                    break;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean updateTokenFile(String directory, String fileName, String token) {
        if (StringUtils.isEmpty(token)) {
            return false;
        }
        if (!ConfigFileUtil.checkFile(directory, fileName, true)) {
            return false;
        }
        Path tokenFilePath = Paths.get(directory.trim(), fileName);
        try (FileWriter writer = new FileWriter(tokenFilePath.toFile());){
            writer.write(TOKEN_FILE_TOKEN + '=' + token);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            ApiLogger.error("write file fail:" + tokenFilePath.toAbsolutePath(), e);
            return false;
        }
    }

    public static Map<String, String> readPropertiesFile(Path configFilePath) {
        return ConfigFileUtil.readPropertiesFile(configFilePath, null);
    }

    public static Map<String, String> readPropertiesFile(Path configFilePath, Set<String> includeKeys) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(configFilePath.toFile()));){
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                int idx;
                if (line.startsWith(UTF8_BOM)) {
                    line = line.substring(1);
                }
                if ((line = line.trim()).isEmpty() || line.startsWith(COMMENT_PREFIX) || (idx = line.indexOf(61)) <= 0 || idx == line.length() - 1) continue;
                String fieldname = line.substring(0, idx).trim();
                if (includeKeys != null && includeKeys.size() != 0 && !includeKeys.contains(fieldname)) continue;
                dataMap.put(fieldname, line.substring(idx + 1).trim());
            }
        }
        catch (IOException e) {
            ApiLogger.error("read file fail:" + configFilePath.toAbsolutePath(), e);
        }
        return dataMap;
    }

    public static String readPrivateKey(String privateKeyFile) {
        String content = "";
        File file = new File(privateKeyFile);
        try (FileInputStream in = new FileInputStream(file);){
            int size = in.available();
            byte[] buffer = new byte[size];
            in.read(buffer);
            content = ConfigFileUtil.processPrivateKey(new String(buffer, TigerApiConstants.CHARSET_UTF8));
        }
        catch (IOException e) {
            ApiLogger.error("read file fail:" + privateKeyFile, e);
        }
        return content;
    }

    public static String processPrivateKey(String content) {
        int start = 0;
        int startIdx = content.indexOf(PPRVATE_KEY_PREFIX);
        if (startIdx > 0) {
            start = startIdx + PPRVATE_KEY_PREFIX.length();
        }
        int end = content.length();
        int endIndex = content.indexOf(PRIVATE_KEY_SUFFIX);
        if (endIndex > 0) {
            end = endIndex;
        }
        return ConfigFileUtil.trim(content, start, end);
    }

    private static String trim(String content, int start, int end) {
        StringBuilder builder = new StringBuilder();
        for (int i = start; i < end; ++i) {
            char ch = content.charAt(i);
            if (ch == '\n' || ch == '\r' || ch == ' ') continue;
            builder.append(ch);
        }
        return builder.toString();
    }

    public static long tryGetCreateTime(String token) {
        long tokenCreateTime = 0L;
        if (!StringUtils.isEmpty(token)) {
            try {
                tokenCreateTime = ConfigFileUtil.getCreateTime(token);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return tokenCreateTime;
    }

    public static long getCreateTime(String token) {
        String text = new String(Base64.getDecoder().decode(token.getBytes(TigerApiConstants.CHARSET_UTF8)), TigerApiConstants.CHARSET_UTF8);
        int idx = text.indexOf(",");
        if (idx > 0) {
            return Long.parseLong(text.substring(0, idx));
        }
        return 0L;
    }

    public static long getExpiredTime(String token) {
        String text = new String(Base64.getDecoder().decode(token.getBytes(TigerApiConstants.CHARSET_UTF8)), TigerApiConstants.CHARSET_UTF8);
        int idx = text.indexOf(",");
        if (idx > 0) {
            return Long.parseLong(text.substring(idx + 1, idx + 14));
        }
        return 0L;
    }

    static {
        configFileKeys.add(CONFIG_FILE_PRIVATE_KEY);
        configFileKeys.add(CONFIG_FILE_TIGER_ID);
        configFileKeys.add(CONFIG_FILE_ACCOUNT);
        configFileKeys.add(CONFIG_FILE_LICENSE);
        configFileKeys.add(CONFIG_FILE_ENV);
    }
}

