/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.util.builder;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tigerbrokers.stock.openapi.client.config.ClientConfig;
import com.tigerbrokers.stock.openapi.client.struct.enums.KType;
import com.tigerbrokers.stock.openapi.client.struct.enums.Language;
import com.tigerbrokers.stock.openapi.client.struct.enums.Market;
import com.tigerbrokers.stock.openapi.client.struct.enums.TimeLineType;
import com.tigerbrokers.stock.openapi.client.struct.enums.TimeZoneId;
import com.tigerbrokers.stock.openapi.client.struct.param.QuoteParameter;
import com.tigerbrokers.stock.openapi.client.util.DateUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QuoteParamBuilder {
    private Map<String, Object> paramMap = new HashMap<String, Object>();

    private QuoteParamBuilder() {
    }

    public static QuoteParamBuilder instance() {
        return new QuoteParamBuilder();
    }

    public QuoteParamBuilder period(KType period) {
        if (period != null) {
            if (period.name().startsWith("min")) {
                String ktypeName = "";
                switch (period) {
                    case min1: {
                        ktypeName = "1min";
                        break;
                    }
                    case min5: {
                        ktypeName = "5min";
                        break;
                    }
                    case min15: {
                        ktypeName = "15min";
                        break;
                    }
                    case min30: {
                        ktypeName = "30min";
                        break;
                    }
                    case min60: {
                        ktypeName = "60min";
                    }
                }
                this.paramMap.put("period", ktypeName);
            } else {
                this.paramMap.put("period", period.name());
            }
        }
        return this;
    }

    public QuoteParamBuilder period(TimeLineType period) {
        if (period != null) {
            switch (period) {
                case day: {
                    this.paramMap.put("period", "day");
                    break;
                }
                case day5: {
                    this.paramMap.put("period", "5day");
                }
            }
        }
        return this;
    }

    public QuoteParamBuilder symbol(String symbol) {
        if (symbol != null) {
            this.paramMap.put("symbol", symbol);
        }
        return this;
    }

    public QuoteParamBuilder symbols(List<String> symbols) {
        if (symbols != null) {
            this.paramMap.put("symbols", symbols);
        }
        return this;
    }

    public QuoteParamBuilder beginTime(Long beginTime) {
        if (beginTime != null && beginTime > 0L) {
            this.paramMap.put("begin_time", beginTime);
        }
        return this;
    }

    public QuoteParamBuilder beginTime(String beginTime) {
        return this.beginTime(beginTime, ClientConfig.DEFAULT_CONFIG.getDefaultTimeZone());
    }

    public QuoteParamBuilder beginTime(String beginTime, TimeZoneId zoneId) {
        return this.setTime("begin_time", beginTime, zoneId);
    }

    public QuoteParamBuilder endTime(Long endTime) {
        if (endTime != null && endTime > 0L) {
            this.paramMap.put("end_time", endTime);
        }
        return this;
    }

    public QuoteParamBuilder endTime(String endTime) {
        return this.endTime(endTime, ClientConfig.DEFAULT_CONFIG.getDefaultTimeZone());
    }

    public QuoteParamBuilder endTime(String endTime, TimeZoneId zoneId) {
        return this.setTime("end_time", endTime, zoneId);
    }

    public QuoteParamBuilder setTime(String key, String time, TimeZoneId zoneId) {
        Date date = DateUtils.getZoneDate(time, zoneId);
        if (date != null) {
            this.paramMap.put(key, date.getTime());
        }
        return this;
    }

    public QuoteParamBuilder limit(Integer limit) {
        if (limit != null) {
            this.paramMap.put("limit", limit);
        }
        return this;
    }

    public QuoteParamBuilder right(String right) {
        if (right != null) {
            this.paramMap.put("right", right);
        }
        return this;
    }

    public QuoteParamBuilder hourTrading(Boolean hourTrading) {
        if (hourTrading != null) {
            this.paramMap.put("include_hour_trading", hourTrading);
        }
        return this;
    }

    public QuoteParamBuilder askBid(Boolean askBid) {
        if (askBid != null) {
            this.paramMap.put("include_ask_bid", askBid);
        }
        return this;
    }

    public QuoteParamBuilder market(Market market) {
        if (market != null) {
            this.paramMap.put("market", (Object)market);
        }
        return this;
    }

    public QuoteParamBuilder beginIndex(Integer beginIndex) {
        if (beginIndex != null) {
            this.paramMap.put("begin_index", beginIndex);
        }
        return this;
    }

    public QuoteParamBuilder endIndex(Integer endIndex) {
        if (endIndex != null) {
            this.paramMap.put("end_index", endIndex);
        }
        return this;
    }

    public QuoteParamBuilder language(Language language) {
        if (language != null) {
            this.paramMap.put("lang", language.name());
        }
        return this;
    }

    public QuoteParamBuilder industryId(Integer industryId) {
        if (industryId != null) {
            this.paramMap.put("industry_id", industryId);
        }
        return this;
    }

    public QuoteParamBuilder industryLevel(String industryLevel) {
        if (industryLevel != null) {
            this.paramMap.put("industry_level", industryLevel);
        }
        return this;
    }

    public QuoteParameter build() {
        return (QuoteParameter)JSONObject.parseObject((String)JSON.toJSONString(this.paramMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteEnumUsingToString}), QuoteParameter.class);
    }

    public String buildJson() {
        return JSONObject.toJSONString(this.paramMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteEnumUsingToString});
    }
}

