/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.util;

import com.alibaba.fastjson.JSON;
import com.tigerbrokers.stock.openapi.client.config.ClientConfig;
import com.tigerbrokers.stock.openapi.client.struct.enums.BizType;
import com.tigerbrokers.stock.openapi.client.struct.enums.Env;
import com.tigerbrokers.stock.openapi.client.struct.enums.License;
import com.tigerbrokers.stock.openapi.client.struct.enums.Protocol;
import com.tigerbrokers.stock.openapi.client.util.ApiLogger;
import com.tigerbrokers.stock.openapi.client.util.HttpUtils;
import com.tigerbrokers.stock.openapi.client.util.StringUtils;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslProvider;
import java.lang.reflect.Field;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class NetworkUtil {
    private static final String GET_DEVICE_ERROR = "please check network connection";
    private static final int MAC_ARRAY_LENGTH = 6;
    private static final int MAC_LENGTH = 17;

    private NetworkUtil() {
    }

    public static String getDeviceId() {
        InetAddress inetAddress = null;
        try {
            inetAddress = NetworkUtil.getLocalHostLANAddress();
        }
        catch (Throwable th) {
            ApiLogger.error("getLocalHostLANAddress failed. {}, {}", (Object)th.getMessage(), (Object)GET_DEVICE_ERROR);
        }
        return NetworkUtil.getMacFromInetAddress(inetAddress);
    }

    public static String getMacFromInetAddress(InetAddress inetAddress) {
        byte[] mac = null;
        if (inetAddress != null) {
            try {
                mac = NetworkInterface.getByInetAddress(inetAddress).getHardwareAddress();
            }
            catch (Throwable th) {
                ApiLogger.info("getHardwareAddress failed. {}", th.getMessage());
            }
        }
        if (mac == null || mac.length != 6) {
            String[] items;
            String ip;
            if (inetAddress != null && inetAddress instanceof Inet6Address) {
                ip = inetAddress.getHostAddress();
                items = ip.split("\\:");
                StringBuilder builder = new StringBuilder();
                for (String item : items) {
                    if (item == null || item.length() == 0 || "0".equals(item)) continue;
                    if (item.length() == 3 || item.length() == 1) {
                        item = "0" + item;
                    }
                    if (item.length() == 4) {
                        builder.append(item, 0, 2).append(':');
                        builder.append(item, 2, 4).append(':');
                        continue;
                    }
                    if (item.length() != 2) continue;
                    builder.append(item, 0, 2).append(':');
                }
                if (builder.length() >= 17) {
                    return builder.substring(0, 17);
                }
            }
            mac = new byte[6];
            if (inetAddress != null && inetAddress instanceof Inet4Address) {
                ip = inetAddress.getHostAddress();
                items = ip.split("\\.");
                for (int i = 0; i < 6; ++i) {
                    mac[i] = (byte)StringUtils.toInt(items[i % items.length], 0);
                }
            } else {
                Random random = new Random(System.currentTimeMillis());
                for (int i = 0; i < 6; ++i) {
                    mac[i] = (byte)random.nextInt(255);
                }
            }
        }
        StringBuilder deviceId = new StringBuilder();
        for (int i = 0; i < mac.length; ++i) {
            String str;
            if (i != 0) {
                deviceId.append(":");
            }
            if ((str = Integer.toHexString(mac[i] & 0xFF)).length() == 1) {
                deviceId.append(0);
            }
            deviceId.append(str);
        }
        return deviceId.toString();
    }

    private static InetAddress getLocalHostLANAddress() throws UnknownHostException {
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                if (networkInterface.isLoopback() || networkInterface.isVirtual() || networkInterface.isPointToPoint() || !networkInterface.isUp()) continue;
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    if (inetAddress.isSiteLocalAddress()) {
                        return inetAddress;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddress;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return jdkSuppliedAddress;
        }
        catch (Exception e) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address: " + e);
            unknownHostException.initCause(e);
            throw unknownHostException;
        }
    }

    public static String[] getSupportedProtocolsSet(String[] serverSupportedProtocols, SslProvider sslProvider) {
        if (serverSupportedProtocols == null || serverSupportedProtocols.length == 0) {
            ApiLogger.error("Server Supported protocols (OpenSSL) is empty. serverSupportedProtocols:{}", serverSupportedProtocols);
            return serverSupportedProtocols;
        }
        Set<String> localSupportedProtocols = sslProvider == SslProvider.JDK ? NetworkUtil.getJdkSupportedProtocolsSet() : NetworkUtil.getOpenSSLSupportedProtocolsSet();
        if (localSupportedProtocols.isEmpty()) {
            ApiLogger.error("Local Supported protocols ({}): {}, is empty", (Object)sslProvider, localSupportedProtocols);
            return null;
        }
        ApiLogger.info("Local Supported protocols ({}): {}", sslProvider, localSupportedProtocols);
        LinkedHashSet<String> supportedProtocolsSet = new LinkedHashSet<String>();
        for (String protocol : serverSupportedProtocols) {
            if (!localSupportedProtocols.contains(protocol)) continue;
            supportedProtocolsSet.add(protocol);
        }
        if (supportedProtocolsSet.isEmpty()) {
            String[] supportedProtocols = new String[serverSupportedProtocols.length];
            System.arraycopy(serverSupportedProtocols, 0, supportedProtocols, 0, serverSupportedProtocols.length);
            return supportedProtocols;
        }
        return supportedProtocolsSet.toArray(new String[supportedProtocolsSet.size()]);
    }

    private static Set<String> getJdkSupportedProtocolsSet() {
        SSLSocket socket = null;
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, null, null);
            SSLSocketFactory factory = context.getSocketFactory();
            socket = (SSLSocket)factory.createSocket();
        }
        catch (Throwable th) {
            ApiLogger.error("getJdkSupportedProtocolsSet exception:{}", (Object)th.getMessage(), (Object)th);
        }
        if (socket == null || socket.getSupportedProtocols() == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> localSupportedProtocols = new LinkedHashSet<String>();
        for (String protocol : socket.getSupportedProtocols()) {
            localSupportedProtocols.add(protocol);
        }
        return localSupportedProtocols;
    }

    private static Set<String> getOpenSSLSupportedProtocolsSet() {
        Set localSupportedProtocols = Collections.emptySet();
        try {
            Field supportedProtocolsSetField = OpenSsl.class.getDeclaredField("SUPPORTED_PROTOCOLS_SET");
            if (supportedProtocolsSetField != null) {
                supportedProtocolsSetField.setAccessible(true);
                localSupportedProtocols = (Set)supportedProtocolsSetField.get(OpenSsl.class);
            }
        }
        catch (Throwable th) {
            ApiLogger.error("getOpenSSLSupportedProtocolsSet exception:{}", (Object)th.getMessage(), (Object)th);
        }
        return localSupportedProtocols;
    }

    private static String getDefaultPort(ClientConfig clientConfig, Protocol protocol) {
        String port = "";
        if (protocol != Protocol.HTTP) {
            port = clientConfig.getEnv() == Env.PROD ? (clientConfig.isSslSocket ? "9883" : "9887") : (clientConfig.isSslSocket ? "9885" : "9889");
        }
        return port;
    }

    public static String getHttpServerAddress(String originalAddress) {
        return StringUtils.defaultIfEmpty(NetworkUtil.getHttpServerAddress(null, originalAddress).get((Object)BizType.COMMON), originalAddress);
    }

    public static Map<BizType, String> getHttpServerAddress(License license, String originalAddress) {
        return NetworkUtil.refreshAndGetServerAddress(Protocol.HTTP, license, originalAddress);
    }

    public static String getServerAddress(String originalAddress) {
        return StringUtils.defaultIfEmpty(NetworkUtil.refreshAndGetServerAddress(ClientConfig.DEFAULT_CONFIG.isSslSocket ? Protocol.SECURE_SOCKET : Protocol.WEB_SOCKET, null, originalAddress).get((Object)BizType.SOCKET), originalAddress);
    }

    private static Map<BizType, String> refreshAndGetServerAddress(final Protocol protocol, License license, String originalAddress) {
        ClientConfig clientConfig = ClientConfig.DEFAULT_CONFIG;
        Env env = clientConfig.getEnv();
        String port = NetworkUtil.getDefaultPort(clientConfig, protocol);
        String commonUrl = null;
        String domainGardenResponse = null;
        List domainConfigList = Collections.emptyList();
        try {
            domainGardenResponse = HttpUtils.get("https://cg.play-analytics.com/");
            Map domainConfigMap = (Map)JSON.parseObject((String)domainGardenResponse, Map.class);
            if (domainConfigMap != null && domainConfigMap.get("items") != null) {
                domainConfigList = (List)domainConfigMap.get("items");
            }
        }
        catch (Throwable th) {
            ApiLogger.warn("domain garden return:{}, error:{}", domainGardenResponse, th.getMessage());
        }
        if (domainConfigList.isEmpty()) {
            final String addressUrl = StringUtils.isEmpty(originalAddress) ? String.format(protocol.getUrlFormat(), NetworkUtil.getDefaultUrl(env, protocol), port) : originalAddress;
            return new HashMap<BizType, String>(){
                {
                    this.put(protocol == Protocol.HTTP ? BizType.COMMON : BizType.SOCKET, addressUrl);
                }
            };
        }
        HashMap<BizType, String> domainUrlMap = new HashMap<BizType, String>();
        for (Map configMap : domainConfigList) {
            Object openapiConfig = configMap.get(env.getConfigFieldName());
            if (openapiConfig == null || !(openapiConfig instanceof Map)) continue;
            Map dataMap = (Map)openapiConfig;
            for (Map.Entry entry : dataMap.entrySet()) {
                if (Protocol.WEB_SOCKET.getPortFieldName().equals(entry.getKey()) || Protocol.SECURE_SOCKET.getPortFieldName().equals(entry.getKey())) {
                    if (!protocol.getPortFieldName().equals(entry.getKey())) continue;
                    port = entry.getValue().toString();
                    continue;
                }
                String domainUrl = entry.getValue().toString().replace("https://", "");
                BizType bizType = NetworkUtil.convertBizType(license, (String)entry.getKey());
                if (bizType != null) {
                    domainUrlMap.put(bizType, String.format(protocol.getUrlFormat(), domainUrl, port));
                }
                commonUrl = commonUrl == null && bizType == BizType.COMMON ? domainUrl : commonUrl;
            }
        }
        if (commonUrl == null) {
            commonUrl = NetworkUtil.getDefaultUrl(env, protocol);
        }
        if (!StringUtils.isEmpty(commonUrl)) {
            domainUrlMap.put(BizType.COMMON, String.format(protocol.getUrlFormat(), commonUrl, port));
            if (protocol != Protocol.HTTP) {
                domainUrlMap.put(BizType.SOCKET, String.format(protocol.getUrlFormat(), commonUrl, port));
            }
        }
        return domainUrlMap;
    }

    private static String getDefaultUrl(Env env, Protocol protocol) {
        if (env == null) {
            return "openapi.tigerfintech.com";
        }
        switch (env) {
            case SANDBOX: {
                return "openapi-sandbox.tigerfintech.com";
            }
            case TEST: {
                return null;
            }
        }
        return "openapi.tigerfintech.com";
    }

    private static BizType convertBizType(License license, String key) {
        if (BizType.COMMON.name().equals(key)) {
            return BizType.COMMON;
        }
        if (license != null) {
            if (license.name().equals(key)) {
                return BizType.TRADE;
            }
            if (key.equals(license.name() + "-" + BizType.QUOTE.name())) {
                return BizType.QUOTE;
            }
            if (key.equals(license.name() + "-" + BizType.PAPER.name())) {
                return BizType.PAPER;
            }
        }
        return null;
    }
}

