/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.util;

import com.tigerbrokers.stock.openapi.client.socket.data.pb.QuoteBBOData;
import com.tigerbrokers.stock.openapi.client.socket.data.pb.QuoteBasicData;
import com.tigerbrokers.stock.openapi.client.socket.data.pb.QuoteData;
import com.tigerbrokers.stock.openapi.client.socket.data.pb.SocketCommon;

public class QuoteDataUtil {
    public static QuoteBBOData convertToAskBidData(QuoteData quoteData) {
        if (quoteData == null || quoteData.getType() == null) {
            return null;
        }
        SocketCommon.QuoteType type = quoteData.getType();
        if (SocketCommon.QuoteType.ALL != type && SocketCommon.QuoteType.BBO != type) {
            return null;
        }
        QuoteBBOData.Builder builder = QuoteBBOData.newBuilder();
        builder.setSymbol(quoteData.getSymbol());
        builder.setType(SocketCommon.QuoteType.BBO);
        builder.setTimestamp(quoteData.getTimestamp());
        builder.setAskPrice(quoteData.getAskPrice());
        builder.setAskSize(quoteData.getAskSize());
        builder.setBidPrice(quoteData.getBidPrice());
        builder.setBidSize(quoteData.getBidSize());
        if (quoteData.hasAskTimestamp()) {
            builder.setAskTimestamp(quoteData.getAskTimestamp());
        }
        if (quoteData.hasBidTimestamp()) {
            builder.setBidTimestamp(quoteData.getBidTimestamp());
        }
        return builder.build();
    }

    public static QuoteBasicData convertToBasicData(QuoteData quoteData) {
        if (quoteData == null || quoteData.getType() == null) {
            return null;
        }
        SocketCommon.QuoteType type = quoteData.getType();
        if (SocketCommon.QuoteType.ALL != type && SocketCommon.QuoteType.BASIC != type) {
            return null;
        }
        QuoteBasicData.Builder builder = QuoteBasicData.newBuilder();
        builder.setSymbol(quoteData.getSymbol());
        builder.setType(SocketCommon.QuoteType.BASIC);
        builder.setTimestamp(quoteData.getTimestamp());
        if (quoteData.hasServerTimestamp()) {
            builder.setServerTimestamp(quoteData.getServerTimestamp());
        }
        if (quoteData.hasAvgPrice()) {
            builder.setAvgPrice(quoteData.getAvgPrice());
        }
        builder.setLatestPrice(quoteData.getLatestPrice());
        if (quoteData.hasLatestPriceTimestamp()) {
            builder.setLatestPriceTimestamp(quoteData.getLatestPriceTimestamp());
        }
        builder.setLatestTime(quoteData.getLatestTime());
        builder.setPreClose(quoteData.getPreClose());
        builder.setVolume(quoteData.getVolume());
        if (quoteData.hasAmount()) {
            builder.setAmount(quoteData.getAmount());
        }
        if (quoteData.hasOpen()) {
            builder.setOpen(quoteData.getOpen());
        }
        if (quoteData.hasHigh()) {
            builder.setHigh(quoteData.getHigh());
        }
        if (quoteData.hasLow()) {
            builder.setLow(quoteData.getLow());
        }
        if (quoteData.hasHourTradingTag()) {
            builder.setHourTradingTag(quoteData.getHourTradingTag());
        }
        if (quoteData.hasMarketStatus()) {
            builder.setMarketStatus(quoteData.getMarketStatus());
        }
        if (quoteData.hasIdentifier()) {
            builder.setIdentifier(quoteData.getIdentifier());
        }
        if (quoteData.hasOpenInt()) {
            builder.setOpenInt(quoteData.getOpenInt());
        }
        if (quoteData.hasTradeTime()) {
            builder.setTradeTime(quoteData.getTradeTime());
        }
        if (quoteData.hasPreSettlement()) {
            builder.setPreSettlement(quoteData.getPreSettlement());
        }
        if (quoteData.hasMinTick()) {
            builder.setMinTick(quoteData.getMinTick());
        }
        if (quoteData.hasMi()) {
            builder.setMi(quoteData.getMi());
        }
        return builder.build();
    }
}

