/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.https.request.future;

import com.tigerbrokers.stock.openapi.client.config.ClientConfig;
import com.tigerbrokers.stock.openapi.client.https.domain.future.model.FutureHistoryMainContractModel;
import com.tigerbrokers.stock.openapi.client.https.request.TigerCommonRequest;
import com.tigerbrokers.stock.openapi.client.https.request.TigerRequest;
import com.tigerbrokers.stock.openapi.client.https.response.future.FutureHistoryMainContractResponse;
import com.tigerbrokers.stock.openapi.client.struct.enums.MethodName;
import com.tigerbrokers.stock.openapi.client.struct.enums.TimeZoneId;
import com.tigerbrokers.stock.openapi.client.util.DateUtils;
import java.util.List;

public class FutureHistoryMainContractRequest
extends TigerCommonRequest
implements TigerRequest<FutureHistoryMainContractResponse> {
    public FutureHistoryMainContractRequest() {
        this.setApiVersion("1.0");
        this.setApiMethodName(MethodName.FUTURE_HISTORY_MAIN_CONTRACT);
    }

    public static FutureHistoryMainContractRequest newRequest(List<String> contractCodes, Long beginTime, Long endTime) {
        FutureHistoryMainContractRequest request = new FutureHistoryMainContractRequest();
        FutureHistoryMainContractModel model = new FutureHistoryMainContractModel(contractCodes, beginTime, endTime);
        request.setApiModel(model);
        return request;
    }

    public static FutureHistoryMainContractRequest newRequest(List<String> contractCodes, String beginTime, String endTime) {
        return FutureHistoryMainContractRequest.newRequest(contractCodes, beginTime, endTime, ClientConfig.DEFAULT_CONFIG.getDefaultTimeZone());
    }

    public static FutureHistoryMainContractRequest newRequest(List<String> contractCodes, String beginTime, String endTime, TimeZoneId zoneId) {
        FutureHistoryMainContractRequest request = new FutureHistoryMainContractRequest();
        FutureHistoryMainContractModel model = new FutureHistoryMainContractModel(contractCodes, DateUtils.getTimestamp(beginTime, zoneId), DateUtils.getTimestamp(endTime, zoneId));
        request.setApiModel(model);
        return request;
    }

    @Override
    public Class<FutureHistoryMainContractResponse> getResponseClass() {
        return FutureHistoryMainContractResponse.class;
    }
}

