/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.https.request.option;

import com.tigerbrokers.stock.openapi.client.https.domain.option.model.OptionBasicModel;
import com.tigerbrokers.stock.openapi.client.https.domain.option.model.OptionCommonModel;
import com.tigerbrokers.stock.openapi.client.https.request.TigerCommonRequest;
import com.tigerbrokers.stock.openapi.client.https.request.TigerRequest;
import com.tigerbrokers.stock.openapi.client.https.response.option.OptionDepthResponse;
import com.tigerbrokers.stock.openapi.client.struct.enums.Market;
import com.tigerbrokers.stock.openapi.client.struct.enums.MethodName;
import java.util.ArrayList;
import java.util.List;

public class OptionDepthQueryRequest
extends TigerCommonRequest
implements TigerRequest<OptionDepthResponse> {
    public OptionDepthQueryRequest() {
        this.setApiVersion("1.0");
        this.setApiMethodName(MethodName.OPTION_DEPTH);
    }

    public OptionDepthQueryRequest(List<OptionCommonModel> items) {
        this(items, null);
    }

    public OptionDepthQueryRequest(List<OptionCommonModel> items, Market market) {
        this();
        OptionBasicModel depthModel = new OptionBasicModel();
        depthModel.setOptionBasic(items);
        depthModel.setMarket(market == null ? Market.US : market);
        this.setApiModel(depthModel);
    }

    public OptionDepthQueryRequest market(Market market) {
        ((OptionBasicModel)this.getApiModel()).setMarket(market == null ? Market.US : market);
        return this;
    }

    public static OptionDepthQueryRequest of(List<OptionCommonModel> items) {
        return new OptionDepthQueryRequest(items);
    }

    public static OptionDepthQueryRequest of(OptionCommonModel ... itemArray) {
        ArrayList<OptionCommonModel> items = new ArrayList<OptionCommonModel>();
        if (itemArray != null && itemArray.length > 0) {
            for (OptionCommonModel model : itemArray) {
                items.add(model);
            }
        }
        return new OptionDepthQueryRequest(items);
    }

    @Override
    public Class<OptionDepthResponse> getResponseClass() {
        return OptionDepthResponse.class;
    }
}

