/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.https.request.option;

import com.tigerbrokers.stock.openapi.client.config.ClientConfig;
import com.tigerbrokers.stock.openapi.client.https.domain.option.model.OptionModel;
import com.tigerbrokers.stock.openapi.client.https.request.TigerCommonRequest;
import com.tigerbrokers.stock.openapi.client.https.request.TigerRequest;
import com.tigerbrokers.stock.openapi.client.https.response.option.OptionSymbolResponse;
import com.tigerbrokers.stock.openapi.client.struct.enums.Language;
import com.tigerbrokers.stock.openapi.client.struct.enums.Market;
import com.tigerbrokers.stock.openapi.client.struct.enums.MethodName;

public class OptionSymbolRequest
extends TigerCommonRequest
implements TigerRequest<OptionSymbolResponse> {
    public OptionSymbolRequest() {
        this.setApiVersion("1.0");
        this.setApiMethodName(MethodName.ALL_HK_OPTION_SYMBOLS);
    }

    public static OptionSymbolRequest newRequest(Market market) {
        return OptionSymbolRequest.newRequest(market, ClientConfig.DEFAULT_CONFIG.getDefaultLanguage());
    }

    public static OptionSymbolRequest newRequest(Market market, Language lang) {
        OptionSymbolRequest request = new OptionSymbolRequest();
        OptionModel model = new OptionModel(market, lang);
        request.setApiModel(model);
        return request;
    }

    @Override
    public OptionModel getApiModel() {
        if (this.apiModel == null) {
            this.apiModel = new OptionModel();
        }
        return (OptionModel)this.apiModel;
    }

    public OptionSymbolRequest market(Market market) {
        this.getApiModel().setMarket(market);
        return this;
    }

    public OptionSymbolRequest language(Language language) {
        this.getApiModel().setLang(language);
        return this;
    }

    @Override
    public Class<OptionSymbolResponse> getResponseClass() {
        return OptionSymbolResponse.class;
    }
}

