/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.struct.enums;

public enum PartCode {
    AMEX("a", 0),
    BOX("b", 1),
    CBOE("c", 2),
    EMLD("d", 3),
    EDGX("e", 4),
    GEM("h", 5),
    ISE("i", 6),
    MCRY("j", 7),
    MIAX("m", 8),
    ARCA("n", 9),
    MPRL("p", 10),
    NSDQ("q", 11),
    BX("t", 12),
    C2("w", 13),
    PHLX("x", 14),
    BZX("z", 15),
    MEMX("u", 16);

    static final PartCode[] partCodes;
    final String code;
    final int index;

    private PartCode(String code, int index) {
        this.code = code;
        this.index = index;
    }

    public int index() {
        return this.index;
    }

    public static PartCode of(String code) {
        if (code != null) {
            for (PartCode c : PartCode.values()) {
                if (!c.code.equals(code)) continue;
                return c;
            }
        }
        return null;
    }

    public static PartCode of(int index) {
        return partCodes[index];
    }

    static {
        partCodes = new PartCode[PartCode.values().length];
        PartCode[] var0 = PartCode.values();
        int var1 = var0.length;
        for (int var2 = 0; var2 < var1; ++var2) {
            PartCode pc;
            PartCode.partCodes[pc.index] = pc = var0[var2];
        }
    }
}

