/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.https.request.financial;

import com.tigerbrokers.stock.openapi.client.https.domain.financial.model.FinancialCurrencyModel;
import com.tigerbrokers.stock.openapi.client.https.request.TigerCommonRequest;
import com.tigerbrokers.stock.openapi.client.https.request.TigerRequest;
import com.tigerbrokers.stock.openapi.client.https.response.financial.FinancialCurrencyResponse;
import com.tigerbrokers.stock.openapi.client.struct.enums.Market;
import com.tigerbrokers.stock.openapi.client.struct.enums.MethodName;
import java.util.List;

public class FinancialCurrencyRequest
extends TigerCommonRequest
implements TigerRequest<FinancialCurrencyResponse> {
    public FinancialCurrencyRequest() {
        this.setApiMethodName(MethodName.FINANCIAL_CURRENCY);
    }

    public static FinancialCurrencyRequest newRequest(List<String> symbols, Market market) {
        FinancialCurrencyRequest request = new FinancialCurrencyRequest();
        FinancialCurrencyModel model = new FinancialCurrencyModel();
        model.setSymbols(symbols);
        model.setMarket(market);
        request.setApiModel(model);
        return request;
    }

    @Override
    public FinancialCurrencyModel getApiModel() {
        if (this.apiModel == null) {
            this.apiModel = new FinancialCurrencyModel();
        }
        return (FinancialCurrencyModel)this.apiModel;
    }

    public FinancialCurrencyRequest symbols(List<String> symbols) {
        this.getApiModel().setSymbols(symbols);
        return this;
    }

    public FinancialCurrencyRequest market(Market market) {
        this.getApiModel().setMarket(market);
        return this;
    }

    @Override
    public Class<FinancialCurrencyResponse> getResponseClass() {
        return FinancialCurrencyResponse.class;
    }
}

