/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.util;

import com.tigerbrokers.stock.openapi.client.TigerApiException;
import com.tigerbrokers.stock.openapi.client.config.ClientConfig;
import com.tigerbrokers.stock.openapi.client.https.client.TigerHttpClient;
import com.tigerbrokers.stock.openapi.client.https.domain.future.item.FutureKlineBatchItem;
import com.tigerbrokers.stock.openapi.client.https.domain.future.item.FutureKlineItem;
import com.tigerbrokers.stock.openapi.client.https.domain.future.model.FutureKlineModel;
import com.tigerbrokers.stock.openapi.client.https.domain.quote.item.KlineItem;
import com.tigerbrokers.stock.openapi.client.https.domain.quote.item.KlinePoint;
import com.tigerbrokers.stock.openapi.client.https.request.future.FutureKlineRequest;
import com.tigerbrokers.stock.openapi.client.https.request.quote.QuoteKlineRequest;
import com.tigerbrokers.stock.openapi.client.https.response.future.FutureKlineResponse;
import com.tigerbrokers.stock.openapi.client.https.response.quote.QuoteKlineResponse;
import com.tigerbrokers.stock.openapi.client.struct.enums.FutureKType;
import com.tigerbrokers.stock.openapi.client.struct.enums.KType;
import com.tigerbrokers.stock.openapi.client.struct.enums.RightOption;
import com.tigerbrokers.stock.openapi.client.struct.enums.TigerApiCode;
import com.tigerbrokers.stock.openapi.client.struct.enums.TimeZoneId;
import com.tigerbrokers.stock.openapi.client.util.DateUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class PageTokenUtil {
    public static int DEFAULT_PAGE_SIZE = 1000;
    public static int DEFAULT_BATCH_TIME = 10;
    public static int MAX_TOTAL_SIZE = 10000;
    public static long DEFAULT_TIME_INTERVAL = 2000L;
    public static final KlinePoint RETURN_KLINE = new KlinePoint();
    public static final FutureKlineItem RETURN_FUTURE_KLINE = new FutureKlineItem();

    private PageTokenUtil() {
    }

    public static List<KlinePoint> getKlineByPage(String symbol, KType period, String beginTime, String endTime) throws TigerApiException {
        return PageTokenUtil.getKlineByPage(symbol, period, beginTime, endTime, ClientConfig.DEFAULT_CONFIG.getDefaultTimeZone(), RightOption.br, DEFAULT_PAGE_SIZE, DEFAULT_PAGE_SIZE * DEFAULT_BATCH_TIME, DEFAULT_TIME_INTERVAL);
    }

    public static List<KlinePoint> getKlineByPage(String symbol, KType period, String beginTime, String endTime, int totalSize) throws TigerApiException {
        return PageTokenUtil.getKlineByPage(symbol, period, beginTime, endTime, ClientConfig.DEFAULT_CONFIG.getDefaultTimeZone(), RightOption.br, DEFAULT_PAGE_SIZE, totalSize, DEFAULT_TIME_INTERVAL);
    }

    public static List<KlinePoint> getKlineByPage(String symbol, KType period, String beginTime, String endTime, TimeZoneId zoneId, RightOption right, int pageSize, int totalSize, long timeInterval) throws TigerApiException {
        return PageTokenUtil.getKlineByPage(RETURN_KLINE, symbol, period == null ? null : period.name(), beginTime, endTime, zoneId, right, pageSize, totalSize, timeInterval);
    }

    public static List<FutureKlineItem> getKlineByPage(String symbol, FutureKType period, String beginTime, String endTime) throws TigerApiException {
        return PageTokenUtil.getKlineByPage(symbol, period, beginTime, endTime, ClientConfig.DEFAULT_CONFIG.getDefaultTimeZone(), DEFAULT_PAGE_SIZE, DEFAULT_PAGE_SIZE * DEFAULT_BATCH_TIME, DEFAULT_TIME_INTERVAL);
    }

    public static List<FutureKlineItem> getKlineByPage(String symbol, FutureKType period, String beginTime, String endTime, int totalSize) throws TigerApiException {
        return PageTokenUtil.getKlineByPage(symbol, period, beginTime, endTime, ClientConfig.DEFAULT_CONFIG.getDefaultTimeZone(), DEFAULT_PAGE_SIZE, totalSize, DEFAULT_TIME_INTERVAL);
    }

    public static List<FutureKlineItem> getKlineByPage(String symbol, FutureKType period, String beginTime, String endTime, TimeZoneId zoneId, int pageSize, int totalSize, long timeInterval) throws TigerApiException {
        return PageTokenUtil.getKlineByPage(RETURN_FUTURE_KLINE, symbol, period == null ? null : period.name(), beginTime, endTime, zoneId, null, pageSize, totalSize, timeInterval);
    }

    public static <T> List<T> getKlineByPage(T t, String symbol, String period, String beginTime, String endTime, TimeZoneId zoneId, RightOption right, int pageSize, int totalSize, long timeInterval) throws TigerApiException {
        return PageTokenUtil.getKlineByPage(TigerHttpClient.getInstance(), t, symbol, period, beginTime, endTime, zoneId, right, pageSize, totalSize, timeInterval);
    }

    public static <T> List<T> getKlineByPage(TigerHttpClient tigerClient, T t, String symbol, String period, String beginTime, String endTime, TimeZoneId zoneId, RightOption right, int pageSize, int totalSize, long timeInterval) throws TigerApiException {
        if (t == null || !(t instanceof KlinePoint) && !(t instanceof FutureKlineItem)) {
            throw new TigerApiException(TigerApiCode.HTTP_BIZ_PARAM_VALUE_ERROR, "return type");
        }
        boolean isKline = t instanceof KlinePoint;
        if (symbol == null) {
            throw new TigerApiException(TigerApiCode.HTTP_BIZ_PARAM_EMPTY_ERROR, "symbol");
        }
        if (totalSize <= 0) {
            totalSize = DEFAULT_PAGE_SIZE * DEFAULT_BATCH_TIME;
        }
        if (totalSize > MAX_TOTAL_SIZE) {
            throw new TigerApiException(TigerApiCode.HTTP_BIZ_PARAM_ERROR, "'totalSize' exceeds maximum: " + MAX_TOTAL_SIZE);
        }
        if (pageSize <= 0) {
            pageSize = DEFAULT_PAGE_SIZE;
        }
        if (totalSize < pageSize) {
            pageSize = totalSize;
        }
        if (zoneId == null) {
            zoneId = tigerClient.getClientConfig().getDefaultTimeZone();
        }
        if (timeInterval < 1000L) {
            timeInterval = DEFAULT_TIME_INTERVAL;
        }
        ArrayList<Serializable> results = new ArrayList<Serializable>(totalSize);
        ArrayList<String> symbols = new ArrayList<String>();
        symbols.add(symbol);
        if (isKline) {
            KType kType = KType.day;
            if (period != null && KType.valueOf(period) != null) {
                kType = KType.valueOf(period);
            }
            QuoteKlineRequest request = QuoteKlineRequest.newRequest(symbols, kType, beginTime, endTime, zoneId);
            request.withLimit(pageSize);
            request.withRight(right == null ? RightOption.br : right);
            do {
                QuoteKlineResponse response;
                if (!(response = tigerClient.execute(request)).isSuccess()) {
                    throw new TigerApiException(response.getMessage());
                }
                if (response.getKlineItems().size() == 0) break;
                KlineItem klineItem = response.getKlineItems().get(0);
                results.addAll(klineItem.getItems());
                if (klineItem.getNextPageToken() == null) break;
                try {
                    TimeUnit.MILLISECONDS.sleep(timeInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                request.withPageToken(klineItem.getNextPageToken());
                if (results.size() + pageSize <= totalSize) continue;
                request.getApiModel().setLimit(totalSize - results.size());
            } while (results.size() < totalSize);
        } else {
            Date beginDate = DateUtils.getZoneDate(beginTime, zoneId);
            if (beginDate == null) {
                throw new TigerApiException(TigerApiCode.HTTP_BIZ_PARAM_VALUE_ERROR, "beginTime");
            }
            Date endDate = DateUtils.getZoneDate(endTime, zoneId);
            if (endDate == null) {
                throw new TigerApiException(TigerApiCode.HTTP_BIZ_PARAM_VALUE_ERROR, "endTime");
            }
            FutureKType kType = FutureKType.day;
            if (period != null && FutureKType.valueOf(period) != null) {
                kType = FutureKType.valueOf(period);
            }
            FutureKlineRequest request = FutureKlineRequest.newRequest(symbols, kType, beginDate.getTime(), endDate.getTime(), (Integer)pageSize);
            do {
                FutureKlineResponse response;
                if (!(response = tigerClient.execute(request)).isSuccess()) {
                    throw new TigerApiException(response.getMessage());
                }
                if (response.getFutureKlineItems().size() == 0) break;
                FutureKlineBatchItem klineItem = response.getFutureKlineItems().get(0);
                results.addAll(klineItem.getItems());
                if (klineItem.getNextPageToken() == null) break;
                try {
                    TimeUnit.MILLISECONDS.sleep(timeInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                request.withPageToken(klineItem.getNextPageToken());
                if (results.size() + pageSize <= totalSize) continue;
                ((FutureKlineModel)request.getApiModel()).setLimit(totalSize - results.size());
            } while (results.size() < totalSize);
        }
        return results;
    }
}

