/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.ProtocolStringList;
import com.tigerbrokers.stock.openapi.client.socket.data.TradeTick;
import com.tigerbrokers.stock.openapi.client.socket.data.pb.TradeTickData;
import com.tigerbrokers.stock.openapi.client.struct.enums.SecType;
import com.tigerbrokers.stock.openapi.client.util.StringUtils;
import com.tigerbrokers.stock.openapi.client.util.SymbolUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TradeTickUtil {
    private static final Map<String, String> PART_CODE_NAME_MAP = TradeTickUtil.initPartCodeNameMap();
    private static final Map<String, String> PART_CODE_SHORT_NAME_MAP = TradeTickUtil.initPartCodeShortNameMap();
    private static final Map<Character, String> usTradeCondMap = TradeTickUtil.initUsTradeCondMap();
    private static final Map<Character, String> hkTradeCondMap = TradeTickUtil.initHkTradeCondMap();

    private TradeTickUtil() {
    }

    private static Map<String, String> initPartCodeNameMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("a", "NYSE American, LLC (NYSE American)");
        map.put("b", "NASDAQ OMX BX, Inc. (NASDAQ OMX BX)");
        map.put("c", "NYSE National, Inc. (NYSE National)");
        map.put("d", "FINRA Alternative Display Facility (ADF)");
        map.put("h", "MIAX Pearl Exchange, LLC (MIAX)");
        map.put("i", "International Securities Exchange, LLC (ISE)");
        map.put("j", "Cboe EDGA Exchange, Inc. (Cboe EDGA)");
        map.put("k", "Cboe EDGX Exchange, Inc. (Cboe EDGX)");
        map.put("l", "Long-Term Stock Exchange, Inc. (LTSE)");
        map.put("m", "NYSE Chicago, Inc. (NYSE Chicago)");
        map.put("n", "New York Stock Exchange, LLC (NYSE)");
        map.put("p", "NYSE Arca, Inc. (NYSE Arca)");
        map.put("s", "Consolidated Tape System (CTS)");
        map.put("t", "NASDAQ Stock Market, LLC (NASDAQ)");
        map.put("u", "Members Exchange, LLC (MEMX)");
        map.put("v", "Investors\u2019 Exchange, LLC. (IEX)");
        map.put("w", "CBOE Stock Exchange, Inc. (CBSX)");
        map.put("x", "NASDAQ OMX PSX, Inc. (NASDAQ OMX PSX)");
        map.put("y", "Cboe BYX Exchange, Inc. (Cboe BYX)");
        map.put("z", "Cboe BZX Exchange, Inc. (Cboe BZX)");
        return Collections.unmodifiableMap(map);
    }

    private static Map<String, String> initPartCodeShortNameMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("a", "AMEX");
        map.put("b", "BX");
        map.put("c", "NSX");
        map.put("d", "ADF");
        map.put("h", "MIAX");
        map.put("i", "ISE");
        map.put("j", "EDGA");
        map.put("k", "EDGX");
        map.put("l", "LTSE");
        map.put("m", "CHO");
        map.put("n", "NYSE");
        map.put("p", "ARCA");
        map.put("s", "CTS");
        map.put("t", "NSDQ");
        map.put("u", "MEMX");
        map.put("v", "IEX");
        map.put("w", "CBSX");
        map.put("x", "PSX");
        map.put("y", "BYX");
        map.put("z", "BZX");
        return Collections.unmodifiableMap(map);
    }

    private static Map<Character, String> initUsTradeCondMap() {
        HashMap<Character, String> map = new HashMap<Character, String>();
        map.put(Character.valueOf(' '), "US_REGULAR_SALE");
        map.put(Character.valueOf('B'), "US_BUNCHED_TRADE");
        map.put(Character.valueOf('C'), "US_CASH_TRADE");
        map.put(Character.valueOf('F'), "US_INTERMARKET_SWEEP");
        map.put(Character.valueOf('G'), "US_BUNCHED_SOLD_TRADE");
        map.put(Character.valueOf('H'), "US_PRICE_VARIATION_TRADE");
        map.put(Character.valueOf('I'), "US_ODD_LOT_TRADE");
        map.put(Character.valueOf('K'), "US_RULE_127_OR_155_TRADE");
        map.put(Character.valueOf('L'), "US_SOLD_LAST");
        map.put(Character.valueOf('M'), "US_MARKET_CENTER_CLOSE_PRICE");
        map.put(Character.valueOf('N'), "US_NEXT_DAY_TRADE");
        map.put(Character.valueOf('O'), "US_MARKET_CENTER_OPENING_TRADE");
        map.put(Character.valueOf('P'), "US_PRIOR_REFERENCE_PRICE");
        map.put(Character.valueOf('Q'), "US_MARKET_CENTER_OPEN_PRICE");
        map.put(Character.valueOf('R'), "US_SELLER");
        map.put(Character.valueOf('T'), "US_FORM_T");
        map.put(Character.valueOf('U'), "US_EXTENDED_TRADING_HOURS");
        map.put(Character.valueOf('V'), "US_CONTINGENT_TRADE");
        map.put(Character.valueOf('W'), "US_AVERAGE_PRICE_TRADE");
        map.put(Character.valueOf('X'), "US_CROSS_TRADE");
        map.put(Character.valueOf('Z'), "US_SOLD_OUT_OF_SEQUENCE");
        map.put(Character.valueOf('0'), "US_ODD_LOST_CROSS_TRADE");
        map.put(Character.valueOf('4'), "US_DERIVATIVELY_PRICED");
        map.put(Character.valueOf('5'), "US_MARKET_CENTER_RE_OPENING_TRADE");
        map.put(Character.valueOf('6'), "US_MARKET_CENTER_CLOSING_TRADE");
        map.put(Character.valueOf('7'), "US_QUALIFIED_CONTINGENT_TRADE");
        map.put(Character.valueOf('9'), "US_CONSOLIDATED_LAST_PRICE_PER_LISTING_PACKET");
        return Collections.unmodifiableMap(map);
    }

    private static Map<Character, String> initHkTradeCondMap() {
        HashMap<Character, String> map = new HashMap<Character, String>();
        map.put(Character.valueOf(' '), "HK_AUTOMATCH_NORMAL");
        map.put(Character.valueOf('D'), "HK_ODD_LOT_TRADE");
        map.put(Character.valueOf('U'), "HK_AUCTION_TRADE");
        map.put(Character.valueOf('*'), "HK_OVERSEAS_TRADE");
        map.put(Character.valueOf('P'), "HK_LATE_TRADE_OFF_EXCHG");
        map.put(Character.valueOf('M'), "HK_NON_DIRECT_OFF_EXCHG_TRADE");
        map.put(Character.valueOf('X'), "HK_DIRECT_OFF_EXCHG_TRADE");
        map.put(Character.valueOf('Y'), "HK_AUTOMATIC_INTERNALIZED");
        return Collections.unmodifiableMap(map);
    }

    private static String getPartNameByCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return code;
        }
        String name = PART_CODE_NAME_MAP.get(code);
        return name == null ? code : name;
    }

    private static String getPartShortNameByCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return code;
        }
        String name = PART_CODE_SHORT_NAME_MAP.get(code);
        return name == null ? code : name;
    }

    private static String getTradeCondByCode(boolean isUsStockSymbol, Character code) {
        if (code == null) {
            code = Character.valueOf(' ');
        }
        String tradeCond = null;
        tradeCond = isUsStockSymbol ? usTradeCondMap.get(code) : hkTradeCondMap.get(code);
        return tradeCond == null ? String.valueOf(code) : tradeCond;
    }

    public static JSONObject decodeData(JSONObject jsonObject) {
        String symbol = jsonObject.getString("symbol");
        if (SymbolUtil.isFutureSymbol(symbol)) {
            return TradeTickUtil.decodeFutureData(jsonObject);
        }
        return TradeTickUtil.decodeStockData(jsonObject);
    }

    public static JSONObject decodeStockData(JSONObject jsonObject) {
        String symbol = jsonObject.getString("symbol");
        JSONArray timeArray = jsonObject.getJSONArray("times");
        JSONArray pricesArray = jsonObject.getJSONArray("prices");
        JSONArray partCodeArray = jsonObject.getJSONArray("partCode");
        JSONArray volumeArray = jsonObject.getJSONArray("volumes");
        String cond = (String)jsonObject.remove((Object)"cond");
        String tickType = (String)jsonObject.remove((Object)"tickType");
        int startSn = jsonObject.getIntValue("sn");
        boolean isUsStockSymbol = SymbolUtil.isUsStockSymbol(symbol);
        JSONArray tickDetail = new JSONArray(timeArray.size());
        jsonObject.put("ticks", (Object)tickDetail);
        if (timeArray != null && timeArray.size() > 0) {
            long previousTime = 0L;
            double priceBase = jsonObject.getLongValue("priceBase");
            double denominator = Math.pow(10.0, jsonObject.getIntValue("priceOffset"));
            for (int i = 0; i < timeArray.size(); ++i) {
                JSONObject tickData = new JSONObject();
                tickDetail.set(i, (Object)tickData);
                timeArray.set(i, (Object)(previousTime += timeArray.getLongValue(i)));
                pricesArray.set(i, (Object)((priceBase + pricesArray.getDoubleValue(i)) / denominator));
                tickData.put("sn", (Object)startSn++);
                tickData.put("volume", volumeArray.get(i));
                tickData.put("time", timeArray.get(i));
                tickData.put("price", pricesArray.get(i));
                if (i < partCodeArray.size()) {
                    tickData.put("partCode", (Object)TradeTickUtil.getPartShortNameByCode(partCodeArray.getString(i)));
                    tickData.put("partName", (Object)TradeTickUtil.getPartNameByCode(partCodeArray.getString(i)));
                }
                Character condChar = null;
                if (cond != null && cond.length() > i) {
                    condChar = Character.valueOf(cond.charAt(i));
                }
                tickData.put("cond", (Object)TradeTickUtil.getTradeCondByCode(isUsStockSymbol, condChar));
                if (tickType == null || tickType.length() <= i) continue;
                tickData.put("tickType", (Object)tickType.substring(i, i + 1));
            }
        }
        jsonObject.remove((Object)"times");
        jsonObject.remove((Object)"prices");
        jsonObject.remove((Object)"partCode");
        jsonObject.remove((Object)"volumes");
        jsonObject.remove((Object)"priceBase");
        jsonObject.remove((Object)"priceOffset");
        return jsonObject;
    }

    public static JSONObject decodeFutureData(JSONObject jsonObject) {
        JSONArray timeArray = jsonObject.getJSONArray("times");
        JSONArray pricesArray = jsonObject.getJSONArray("prices");
        int startSn = jsonObject.getIntValue("sn");
        JSONArray mergedVolsArray = jsonObject.getJSONArray("mergedVols");
        int totalCount = 0;
        for (int i = 0; i < mergedVolsArray.size(); ++i) {
            totalCount += mergedVolsArray.getJSONObject(i).getIntValue("mergeTimes");
        }
        JSONArray tickDetail = new JSONArray(totalCount);
        jsonObject.put("ticks", (Object)tickDetail);
        if (timeArray != null && timeArray.size() > 0) {
            long previousTime = 0L;
            double priceBase = jsonObject.getLongValue("priceBase");
            double denominator = Math.pow(10.0, jsonObject.getIntValue("priceOffset"));
            int idx = 0;
            for (int i = 0; i < timeArray.size(); ++i) {
                timeArray.set(i, (Object)(previousTime += timeArray.getLongValue(i)));
                pricesArray.set(i, (Object)((priceBase + pricesArray.getDoubleValue(i)) / denominator));
                JSONArray volsArray = mergedVolsArray.getJSONObject(i).getJSONArray("vols");
                int mergeTimes = mergedVolsArray.getJSONObject(i).getIntValue("mergeTimes");
                for (int j = 0; j < mergeTimes; ++j) {
                    JSONObject tickData = new JSONObject();
                    tickDetail.set(idx++, (Object)tickData);
                    tickData.put("sn", (Object)(startSn * 10 + j));
                    tickData.put("volume", volsArray.get(j));
                    tickData.put("time", timeArray.get(i));
                    tickData.put("price", pricesArray.get(i));
                }
                ++startSn;
            }
        }
        jsonObject.remove((Object)"times");
        jsonObject.remove((Object)"prices");
        jsonObject.remove((Object)"volumes");
        jsonObject.remove((Object)"priceBase");
        jsonObject.remove((Object)"priceOffset");
        jsonObject.remove((Object)"mergedVols");
        return jsonObject;
    }

    public static TradeTick convert(TradeTickData source) {
        String secType = source.getSecType();
        if (SecType.FUT.name().equals(secType)) {
            return TradeTickUtil.convertFutureData(source);
        }
        return TradeTickUtil.convertStockData(source);
    }

    public static TradeTick convertStockData(TradeTickData source) {
        TradeTick tradeTick = new TradeTick();
        tradeTick.setSecType(SecType.STK);
        tradeTick.setSymbol(source.getSymbol());
        tradeTick.setQuoteLevel(source.getQuoteLevel());
        tradeTick.setTimestamp(source.getTimestamp());
        List<Long> timeList = source.getTimeList();
        List<Long> pricesList = source.getPriceList();
        ProtocolStringList partCodeList = source.getPartCodeList();
        List<Long> volumeList = source.getVolumeList();
        String cond = source.getCond();
        String tickType = source.getType();
        long startSn = source.getSn();
        boolean isUsStockSymbol = SymbolUtil.isUsStockSymbol(source.getSymbol());
        ArrayList<TradeTick.Tick> ticks = new ArrayList<TradeTick.Tick>(source.getTimeCount());
        tradeTick.setTicks(ticks);
        if (timeList != null && timeList.size() > 0) {
            long currentTime = 0L;
            long priceBase = source.getPriceBase();
            double denominator = Math.pow(10.0, source.getPriceOffset());
            for (int i = 0; i < timeList.size(); ++i) {
                TradeTick.Tick tickData = new TradeTick.Tick();
                ticks.add(tickData);
                tickData.setTime(currentTime += timeList.get(i).longValue());
                tickData.setPrice(((double)priceBase + pricesList.get(i).doubleValue()) / denominator);
                tickData.setSn(startSn++);
                tickData.setVolume(volumeList.get(i));
                if (i < partCodeList.size()) {
                    tickData.setPartCode(TradeTickUtil.getPartShortNameByCode((String)partCodeList.get(i)));
                    tickData.setPartName(TradeTickUtil.getPartNameByCode((String)partCodeList.get(i)));
                }
                Character condChar = null;
                if (cond != null && cond.length() > i) {
                    condChar = Character.valueOf(cond.charAt(i));
                }
                tickData.setCond(TradeTickUtil.getTradeCondByCode(isUsStockSymbol, condChar));
                if (tickType == null || tickType.length() <= i) continue;
                tickData.setTickType(tickType.substring(i, i + 1));
            }
        }
        return tradeTick;
    }

    public static TradeTick convertFutureData(TradeTickData source) {
        TradeTick tradeTick = new TradeTick();
        tradeTick.setSecType(SecType.FUT);
        tradeTick.setSymbol(source.getSymbol());
        tradeTick.setTimestamp(source.getTimestamp());
        List<Long> timeList = source.getTimeList();
        List<Long> pricesList = source.getPriceList();
        long startSn = source.getSn();
        List<TradeTickData.MergedVol> mergedVolsArray = source.getMergedVolsList();
        int totalCount = 0;
        for (TradeTickData.MergedVol item : mergedVolsArray) {
            totalCount += item.getMergeTimes();
        }
        ArrayList<TradeTick.Tick> ticks = new ArrayList<TradeTick.Tick>(totalCount);
        tradeTick.setTicks(ticks);
        if (timeList != null && timeList.size() > 0) {
            long currentTime = 0L;
            long priceBase = source.getPriceBase();
            double denominator = Math.pow(10.0, source.getPriceOffset());
            for (int i = 0; i < timeList.size(); ++i) {
                currentTime += timeList.get(i).longValue();
                double curPrices = ((double)priceBase + pricesList.get(i).doubleValue()) / denominator;
                List<Long> volsList = mergedVolsArray.get(i).getVolList();
                int mergeTimes = mergedVolsArray.get(i).getMergeTimes();
                for (int j = 0; j < mergeTimes; ++j) {
                    TradeTick.Tick tickData = new TradeTick.Tick();
                    ticks.add(tickData);
                    tickData.setSn(startSn * 10L + (long)j);
                    tickData.setVolume(volsList.get(j));
                    tickData.setTime(currentTime);
                    tickData.setPrice(curPrices);
                }
                ++startSn;
            }
        }
        return tradeTick;
    }
}

