/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.util.builder;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tigerbrokers.stock.openapi.client.config.ClientConfig;
import com.tigerbrokers.stock.openapi.client.struct.enums.AssetQuoteType;
import com.tigerbrokers.stock.openapi.client.struct.enums.Currency;
import com.tigerbrokers.stock.openapi.client.struct.enums.Language;
import com.tigerbrokers.stock.openapi.client.struct.enums.Market;
import com.tigerbrokers.stock.openapi.client.struct.enums.OrderSortBy;
import com.tigerbrokers.stock.openapi.client.struct.enums.SecType;
import com.tigerbrokers.stock.openapi.client.struct.enums.SegmentType;
import com.tigerbrokers.stock.openapi.client.struct.enums.TimeZoneId;
import com.tigerbrokers.stock.openapi.client.util.DateUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AccountParamBuilder {
    private Map<String, Object> paramMap = new HashMap<String, Object>();

    private AccountParamBuilder() {
    }

    public static AccountParamBuilder instance() {
        return new AccountParamBuilder();
    }

    public AccountParamBuilder lang(Language lang) {
        if (lang != null) {
            this.paramMap.put("lang", lang.name());
        }
        return this;
    }

    public AccountParamBuilder conid(String conid) {
        if (conid != null) {
            this.paramMap.put("conid", conid);
        }
        return this;
    }

    public AccountParamBuilder account(String account) {
        if (account != null) {
            this.paramMap.put("account", account);
        }
        return this;
    }

    public AccountParamBuilder subAccounts(List<String> subAccounts) {
        if (subAccounts != null) {
            this.paramMap.put("sub_accounts", subAccounts);
        }
        return this;
    }

    public AccountParamBuilder symbol(String symbol) {
        if (symbol != null) {
            this.paramMap.put("symbol", symbol);
        }
        return this;
    }

    public AccountParamBuilder symbols(List<String> symbols) {
        if (symbols != null) {
            this.paramMap.put("symbols", symbols);
        }
        return this;
    }

    public AccountParamBuilder continuous(Boolean continuous) {
        if (continuous != null) {
            this.paramMap.put("continuous", continuous);
        }
        return this;
    }

    public AccountParamBuilder currency(Currency currency) {
        if (currency != null) {
            this.paramMap.put("currency", currency.name());
        }
        return this;
    }

    public AccountParamBuilder exchange(String exchange) {
        if (exchange != null) {
            this.paramMap.put("exchange", exchange);
        }
        return this;
    }

    public AccountParamBuilder market(Market market) {
        if (market != null) {
            this.paramMap.put("market", market.name());
        }
        return this;
    }

    public AccountParamBuilder segment(Boolean segment) {
        if (segment != null) {
            this.paramMap.put("segment", segment);
        }
        return this;
    }

    public AccountParamBuilder marketValue(Boolean marketValue) {
        if (marketValue != null) {
            this.paramMap.put("market_value", marketValue);
        }
        return this;
    }

    public AccountParamBuilder strike(Double strike) {
        if (strike != null) {
            this.paramMap.put("strike", strike);
        }
        return this;
    }

    public AccountParamBuilder expiry(String expiry) {
        if (expiry != null) {
            this.paramMap.put("expiry", expiry);
        }
        return this;
    }

    public AccountParamBuilder right(String right) {
        if (right != null) {
            this.paramMap.put("right", right);
        }
        return this;
    }

    public AccountParamBuilder startDate(Long timestamp) {
        if (timestamp != null && timestamp > 0L) {
            this.paramMap.put("start_date", timestamp);
        }
        return this;
    }

    public AccountParamBuilder startDate(String startDate) {
        return this.setTime("start_date", startDate, ClientConfig.DEFAULT_CONFIG.getDefaultTimeZone());
    }

    public AccountParamBuilder startDate(String startDate, TimeZoneId zoneId) {
        return this.setTime("start_date", startDate, zoneId);
    }

    public AccountParamBuilder endDate(Long timestamp) {
        if (timestamp != null && timestamp > 0L) {
            this.paramMap.put("end_date", timestamp);
        }
        return this;
    }

    public AccountParamBuilder endDate(String endDate) {
        return this.setTime("end_date", endDate, ClientConfig.DEFAULT_CONFIG.getDefaultTimeZone());
    }

    public AccountParamBuilder endDate(String endDate, TimeZoneId zoneId) {
        return this.setTime("end_date", endDate, zoneId);
    }

    public AccountParamBuilder setTime(String key, String time, TimeZoneId zoneId) {
        Date date = DateUtils.getZoneDate(time, zoneId);
        if (date != null) {
            this.paramMap.put(key, date.getTime());
        }
        return this;
    }

    public AccountParamBuilder limit(Integer limit) {
        if (limit != null) {
            this.paramMap.put("limit", limit);
        }
        return this;
    }

    public AccountParamBuilder states(List<String> statusList) {
        if (statusList != null) {
            this.paramMap.put("states", statusList);
        }
        return this;
    }

    public AccountParamBuilder secType(SecType secType) {
        if (secType != null) {
            this.paramMap.put("sec_type", secType.name());
        }
        return this;
    }

    public AccountParamBuilder segType(SegmentType segType) {
        if (segType != null) {
            this.paramMap.put("seg_type", segType.name());
        }
        return this;
    }

    public AccountParamBuilder id(Long id) {
        if (id != null) {
            this.paramMap.put("id", id);
        }
        return this;
    }

    public AccountParamBuilder orderId(Integer orderId) {
        if (orderId != null) {
            this.paramMap.put("order_id", orderId);
        }
        return this;
    }

    public AccountParamBuilder orderId(Long orderId) {
        if (orderId != null) {
            this.paramMap.put("order_id", orderId);
        }
        return this;
    }

    public AccountParamBuilder isBrief(Boolean isBrief) {
        if (isBrief != null) {
            this.paramMap.put("is_brief", isBrief);
        }
        return this;
    }

    public AccountParamBuilder isShowCharges(Boolean isShowCharges) {
        if (isShowCharges != null) {
            this.paramMap.put("show_charges", isShowCharges);
        }
        return this;
    }

    public AccountParamBuilder parentId(Integer parentId) {
        if (parentId != null) {
            this.paramMap.put("parent_id", parentId);
        }
        return this;
    }

    public AccountParamBuilder secretKey(String secretKey) {
        if (secretKey != null) {
            this.paramMap.put("secret_key", secretKey);
        }
        return this;
    }

    public AccountParamBuilder pageToken(String pageToken) {
        if (pageToken != null) {
            this.paramMap.put("page_token", pageToken);
        }
        return this;
    }

    public AccountParamBuilder sortBy(OrderSortBy orderSortBy) {
        if (orderSortBy != null) {
            this.paramMap.put("sort_by", orderSortBy.name());
        }
        return this;
    }

    public AccountParamBuilder assetQuoteType(AssetQuoteType assetQuoteType) {
        if (assetQuoteType != null) {
            this.paramMap.put("asset_quote_type", assetQuoteType.name());
        }
        return this;
    }

    public String buildJson() {
        return this.buildJson(ClientConfig.DEFAULT_CONFIG);
    }

    public String buildJson(ClientConfig clientConfig) {
        if (this.paramMap.get("account") == null) {
            this.paramMap.put("account", clientConfig.defaultAccount);
        }
        return this.buildJsonWithoutDefaultAccount(clientConfig);
    }

    public String buildJsonWithoutDefaultAccount() {
        return this.buildJsonWithoutDefaultAccount(ClientConfig.DEFAULT_CONFIG);
    }

    public String buildJsonWithoutDefaultAccount(ClientConfig clientConfig) {
        if (this.paramMap.get("lang") == null) {
            this.paramMap.put("lang", clientConfig.getDefaultLanguage().name());
        }
        if (this.paramMap.get("secret_key") == null) {
            this.paramMap.put("secret_key", clientConfig.secretKey);
        }
        return JSONObject.toJSONString(this.paramMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteEnumUsingToString});
    }
}

