/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.https.request.option;

import com.tigerbrokers.stock.openapi.client.config.ClientConfig;
import com.tigerbrokers.stock.openapi.client.https.domain.option.model.WarrantFilterModel;
import com.tigerbrokers.stock.openapi.client.https.request.TigerCommonRequest;
import com.tigerbrokers.stock.openapi.client.https.request.TigerRequest;
import com.tigerbrokers.stock.openapi.client.https.response.option.WarrantFilterResponse;
import com.tigerbrokers.stock.openapi.client.struct.enums.Language;
import com.tigerbrokers.stock.openapi.client.struct.enums.MethodName;
import com.tigerbrokers.stock.openapi.client.struct.enums.OptionPrice;
import com.tigerbrokers.stock.openapi.client.struct.enums.SortDir;
import com.tigerbrokers.stock.openapi.client.struct.enums.WarrantState;
import com.tigerbrokers.stock.openapi.client.struct.enums.WarrantType;
import java.util.HashSet;
import java.util.Set;

public class WarrantFilterRequest
extends TigerCommonRequest
implements TigerRequest<WarrantFilterResponse> {
    public WarrantFilterRequest() {
        this.setApiVersion("1.0");
        this.setApiMethodName(MethodName.WARRANT_FILTER);
    }

    public static WarrantFilterRequest newRequest(String symbol) {
        WarrantFilterRequest request = new WarrantFilterRequest();
        WarrantFilterModel model = new WarrantFilterModel(symbol);
        model.setLang(ClientConfig.DEFAULT_CONFIG.getDefaultLanguage());
        request.setApiModel(model);
        return request;
    }

    @Override
    public final WarrantFilterModel getApiModel() {
        WarrantFilterModel model = (WarrantFilterModel)super.getApiModel();
        if (null == model) {
            model = new WarrantFilterModel();
            this.setApiModel(model);
        }
        return model;
    }

    public WarrantFilterRequest lang(Language lang) {
        this.getApiModel().setLang(lang);
        return this;
    }

    public WarrantFilterRequest page(Integer page) {
        this.getApiModel().page(page);
        return this;
    }

    public WarrantFilterRequest pageSize(Integer pageSize) {
        this.getApiModel().pageSize(pageSize);
        return this;
    }

    public WarrantFilterRequest sortFieldName(String sortFieldName) {
        this.getApiModel().sortFieldName(sortFieldName);
        return this;
    }

    public WarrantFilterRequest sortDir(SortDir sortDir) {
        this.getApiModel().sortDir(sortDir);
        return this;
    }

    public WarrantFilterRequest warrantType(WarrantType ... warrantType) {
        if (warrantType != null && warrantType.length > 0) {
            HashSet<Integer> warrantTypeSets = new HashSet<Integer>();
            for (WarrantType item : warrantType) {
                if (item == null) continue;
                warrantTypeSets.add(item.getValue());
            }
            if (warrantTypeSets.size() > 0) {
                this.getApiModel().warrantType(warrantTypeSets);
            }
        }
        return this;
    }

    public WarrantFilterRequest issuerName(String issuerName) {
        this.getApiModel().issuerName(issuerName);
        return this;
    }

    public WarrantFilterRequest expireYM(String expireYM) {
        this.getApiModel().expireYM(expireYM);
        return this;
    }

    public WarrantFilterRequest state(WarrantState state) {
        if (null != state) {
            this.getApiModel().state(state.getValue());
        }
        return this;
    }

    public WarrantFilterRequest inOutPrice(OptionPrice ... inOutPrice) {
        if (inOutPrice != null && inOutPrice.length > 0) {
            HashSet<Integer> inOutPriceSets = new HashSet<Integer>();
            for (OptionPrice item : inOutPrice) {
                if (item == null) continue;
                inOutPriceSets.add(item.getValue());
            }
            if (inOutPriceSets.size() > 0) {
                this.getApiModel().inOutPrice(inOutPriceSets);
            }
        }
        return this;
    }

    public WarrantFilterRequest lotSize(Set<Integer> lotSize) {
        this.getApiModel().lotSize(lotSize);
        return this;
    }

    public WarrantFilterRequest entitlementRatio(Set<Double> entitlementRatio) {
        this.getApiModel().entitlementRatio(entitlementRatio);
        return this;
    }

    public WarrantFilterRequest strike(Double min, Double max) {
        this.getApiModel().strike(min, max);
        return this;
    }

    public WarrantFilterRequest effectiveLeverage(Double min, Double max) {
        this.getApiModel().effectiveLeverage(min, max);
        return this;
    }

    public WarrantFilterRequest leverageRatio(Double min, Double max) {
        this.getApiModel().leverageRatio(min, max);
        return this;
    }

    public WarrantFilterRequest callPrice(Double min, Double max) {
        this.getApiModel().callPrice(min, max);
        return this;
    }

    public WarrantFilterRequest volume(Long min, Long max) {
        this.getApiModel().volume(min, max);
        return this;
    }

    public WarrantFilterRequest premium(Double min, Double max) {
        this.getApiModel().premium(min, max);
        return this;
    }

    public WarrantFilterRequest outstandingRatio(Double min, Double max) {
        this.getApiModel().outstandingRatio(min, max);
        return this;
    }

    public WarrantFilterRequest impliedVolatility(Double min, Double max) {
        this.getApiModel().impliedVolatility(min, max);
        return this;
    }

    @Override
    public Class<WarrantFilterResponse> getResponseClass() {
        return WarrantFilterResponse.class;
    }
}

