/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.https.request.future;

import com.tigerbrokers.stock.openapi.client.config.ClientConfig;
import com.tigerbrokers.stock.openapi.client.https.domain.future.model.FutureKlineModel;
import com.tigerbrokers.stock.openapi.client.https.request.TigerCommonRequest;
import com.tigerbrokers.stock.openapi.client.https.request.TigerRequest;
import com.tigerbrokers.stock.openapi.client.https.response.future.FutureKlineResponse;
import com.tigerbrokers.stock.openapi.client.struct.enums.FutureKType;
import com.tigerbrokers.stock.openapi.client.struct.enums.MethodName;
import com.tigerbrokers.stock.openapi.client.struct.enums.TimeZoneId;
import com.tigerbrokers.stock.openapi.client.util.DateUtils;
import java.util.List;

public class FutureKlineRequest
extends TigerCommonRequest
implements TigerRequest<FutureKlineResponse> {
    private static final long DEFAULT_TIME_RANGE = 604800000L;
    private static final int DEFAULT_LIMIT = 200;

    public FutureKlineRequest() {
        this.setApiVersion("1.0");
        this.setApiMethodName(MethodName.FUTURE_KLINE);
    }

    public static FutureKlineRequest newRequest(List<String> contractCodes) {
        return FutureKlineRequest.newRequest(contractCodes, FutureKType.day, System.currentTimeMillis() - 604800000L, System.currentTimeMillis(), (Integer)200);
    }

    public static FutureKlineRequest newRequest(List<String> contractCodes, FutureKType kType) {
        return FutureKlineRequest.newRequest(contractCodes, kType, System.currentTimeMillis() - 604800000L, System.currentTimeMillis(), (Integer)200);
    }

    public static FutureKlineRequest newRequest(List<String> contractCodes, FutureKType kType, Integer limit) {
        return FutureKlineRequest.newRequest(contractCodes, kType, System.currentTimeMillis() - 604800000L, System.currentTimeMillis(), limit);
    }

    public static FutureKlineRequest newRequest(List<String> contractCodes, FutureKType kType, Long beginTime, Long endTime, Integer limit) {
        FutureKlineRequest request = new FutureKlineRequest();
        FutureKlineModel model = new FutureKlineModel(contractCodes, kType != null ? kType.getValue() : FutureKType.day.getValue(), beginTime, endTime, limit);
        request.setApiModel(model);
        return request;
    }

    public static FutureKlineRequest newRequest(List<String> contractCodes, FutureKType kType, String beginTime, String endTime, Integer limit) {
        return FutureKlineRequest.newRequest(contractCodes, kType, beginTime, endTime, ClientConfig.DEFAULT_CONFIG.getDefaultTimeZone(), limit);
    }

    public static FutureKlineRequest newRequest(List<String> contractCodes, FutureKType kType, String beginTime, String endTime, TimeZoneId zoneId, Integer limit) {
        FutureKlineRequest request = new FutureKlineRequest();
        FutureKlineModel model = new FutureKlineModel(contractCodes, kType != null ? kType.getValue() : FutureKType.day.getValue(), DateUtils.getTimestamp(beginTime, zoneId), DateUtils.getTimestamp(endTime, zoneId), limit);
        request.setApiModel(model);
        return request;
    }

    public void withPageToken(String pageToken) {
        if (this.apiModel != null && this.apiModel instanceof FutureKlineModel) {
            FutureKlineModel model = (FutureKlineModel)this.getApiModel();
            model.setPageToken(pageToken);
        }
    }

    @Override
    public Class<FutureKlineResponse> getResponseClass() {
        return FutureKlineResponse.class;
    }
}

