/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.https.request.quote;

import com.tigerbrokers.stock.openapi.client.config.ClientConfig;
import com.tigerbrokers.stock.openapi.client.https.domain.quote.model.QuoteTimelineModel;
import com.tigerbrokers.stock.openapi.client.https.request.TigerCommonRequest;
import com.tigerbrokers.stock.openapi.client.https.request.TigerRequest;
import com.tigerbrokers.stock.openapi.client.https.response.quote.QuoteTimelineResponse;
import com.tigerbrokers.stock.openapi.client.struct.enums.Language;
import com.tigerbrokers.stock.openapi.client.struct.enums.MethodName;
import com.tigerbrokers.stock.openapi.client.struct.enums.TimeLineType;
import com.tigerbrokers.stock.openapi.client.struct.enums.TimeZoneId;
import com.tigerbrokers.stock.openapi.client.struct.enums.TradeSession;
import com.tigerbrokers.stock.openapi.client.util.DateUtils;
import java.util.Date;
import java.util.List;

public class QuoteTimelineRequest
extends TigerCommonRequest
implements TigerRequest<QuoteTimelineResponse> {
    public QuoteTimelineRequest() {
        this.setApiVersion("3.0");
        this.setApiMethodName(MethodName.TIMELINE);
    }

    public static QuoteTimelineRequest newRequest(List<String> symbols) {
        return QuoteTimelineRequest.newRequest(symbols, null);
    }

    public static QuoteTimelineRequest newRequest(List<String> symbols, Long beginTime) {
        return QuoteTimelineRequest.newRequest(symbols, beginTime, TradeSession.Regular, TimeLineType.day);
    }

    @Deprecated
    public static QuoteTimelineRequest newRequest(List<String> symbols, Long beginTime, boolean includeHourTrading) {
        return QuoteTimelineRequest.newRequest(symbols, beginTime, includeHourTrading ? TradeSession.All : TradeSession.Regular, TimeLineType.day, ClientConfig.DEFAULT_CONFIG.getDefaultLanguage());
    }

    public static QuoteTimelineRequest newRequest(List<String> symbols, Long beginTime, TradeSession tradeSession) {
        return QuoteTimelineRequest.newRequest(symbols, beginTime, tradeSession, TimeLineType.day, ClientConfig.DEFAULT_CONFIG.getDefaultLanguage());
    }

    @Deprecated
    public static QuoteTimelineRequest newRequest(List<String> symbols, Long beginTime, boolean includeHourTrading, Language lang) {
        return QuoteTimelineRequest.newRequest(symbols, beginTime, includeHourTrading ? TradeSession.All : TradeSession.Regular, TimeLineType.day, lang);
    }

    public static QuoteTimelineRequest newRequest(List<String> symbols, Long beginTime, TradeSession tradeSession, Language lang) {
        return QuoteTimelineRequest.newRequest(symbols, beginTime, tradeSession, TimeLineType.day, lang);
    }

    @Deprecated
    public static QuoteTimelineRequest newRequest(List<String> symbols, Long beginTime, TimeLineType timeLineType) {
        return QuoteTimelineRequest.newRequest(symbols, beginTime, TradeSession.All, timeLineType);
    }

    @Deprecated
    public static QuoteTimelineRequest newRequest(List<String> symbols, Long beginTime, boolean includeHourTrading, TimeLineType timeLineType) {
        return QuoteTimelineRequest.newRequest(symbols, beginTime, includeHourTrading ? TradeSession.All : TradeSession.Regular, timeLineType, ClientConfig.DEFAULT_CONFIG.getDefaultLanguage());
    }

    public static QuoteTimelineRequest newRequest(List<String> symbols, Long beginTime, TradeSession tradeSession, TimeLineType timeLineType) {
        return QuoteTimelineRequest.newRequest(symbols, beginTime, tradeSession, timeLineType, ClientConfig.DEFAULT_CONFIG.getDefaultLanguage());
    }

    @Deprecated
    public static QuoteTimelineRequest newRequest(List<String> symbols, Long beginTime, boolean includeHourTrading, TimeLineType timeLineType, Language lang) {
        QuoteTimelineRequest request = new QuoteTimelineRequest();
        QuoteTimelineModel model = new QuoteTimelineModel(symbols, beginTime, includeHourTrading ? TradeSession.All : TradeSession.Regular, timeLineType, lang);
        request.setApiModel(model);
        return request;
    }

    public static QuoteTimelineRequest newRequest(List<String> symbols, Long beginTime, TradeSession tradeSession, TimeLineType timeLineType, Language lang) {
        QuoteTimelineRequest request = new QuoteTimelineRequest();
        QuoteTimelineModel model = new QuoteTimelineModel(symbols, beginTime, tradeSession, timeLineType, lang);
        request.setApiModel(model);
        return request;
    }

    public static QuoteTimelineRequest newRequest(List<String> symbols, String beginTime, TimeLineType timeLineType) {
        return QuoteTimelineRequest.newRequest(symbols, beginTime, ClientConfig.DEFAULT_CONFIG.getDefaultTimeZone(), TradeSession.Regular, timeLineType, ClientConfig.DEFAULT_CONFIG.getDefaultLanguage());
    }

    @Deprecated
    public static QuoteTimelineRequest newRequest(List<String> symbols, String beginTime, boolean includeHourTrading, TimeLineType timeLineType) {
        return QuoteTimelineRequest.newRequest(symbols, beginTime, ClientConfig.DEFAULT_CONFIG.getDefaultTimeZone(), includeHourTrading ? TradeSession.All : TradeSession.Regular, timeLineType, ClientConfig.DEFAULT_CONFIG.getDefaultLanguage());
    }

    public static QuoteTimelineRequest newRequest(List<String> symbols, String beginTime, TradeSession tradeSession, TimeLineType timeLineType) {
        return QuoteTimelineRequest.newRequest(symbols, beginTime, ClientConfig.DEFAULT_CONFIG.getDefaultTimeZone(), tradeSession, timeLineType, ClientConfig.DEFAULT_CONFIG.getDefaultLanguage());
    }

    public static QuoteTimelineRequest newRequest(List<String> symbols, String beginTime, TimeZoneId zoneId, TradeSession tradeSession, TimeLineType timeLineType, Language lang) {
        Date beginDate;
        QuoteTimelineRequest request = new QuoteTimelineRequest();
        if (zoneId == null) {
            zoneId = ClientConfig.DEFAULT_CONFIG.getDefaultTimeZone();
        }
        QuoteTimelineModel model = new QuoteTimelineModel(symbols, (beginDate = DateUtils.getZoneDate(beginTime, zoneId)) == null ? null : Long.valueOf(beginDate.getTime()), tradeSession, timeLineType, lang);
        request.setApiModel(model);
        return request;
    }

    @Override
    public QuoteTimelineModel getApiModel() {
        return (QuoteTimelineModel)this.apiModel;
    }

    public void setTradeSession(TradeSession tradeSession) {
        this.getApiModel().setTradeSession(tradeSession);
    }

    @Override
    public Class<QuoteTimelineResponse> getResponseClass() {
        return QuoteTimelineResponse.class;
    }
}

