/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.socket;

import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.Message;
import com.tigerbrokers.stock.openapi.client.socket.ApiComposeCallback;
import com.tigerbrokers.stock.openapi.client.socket.data.TradeTick;
import com.tigerbrokers.stock.openapi.client.socket.data.pb.KlineData;
import com.tigerbrokers.stock.openapi.client.socket.data.pb.PushData;
import com.tigerbrokers.stock.openapi.client.socket.data.pb.QuoteBBOData;
import com.tigerbrokers.stock.openapi.client.socket.data.pb.QuoteBasicData;
import com.tigerbrokers.stock.openapi.client.socket.data.pb.QuoteDepthData;
import com.tigerbrokers.stock.openapi.client.socket.data.pb.Response;
import com.tigerbrokers.stock.openapi.client.socket.data.pb.SocketCommon;
import com.tigerbrokers.stock.openapi.client.socket.data.pb.TickData;
import com.tigerbrokers.stock.openapi.client.socket.executor.MessageCallbackExecutor;
import com.tigerbrokers.stock.openapi.client.socket.executor.PerDataTypeSingleThreadExecutor;
import com.tigerbrokers.stock.openapi.client.struct.SubscribedSymbol;
import com.tigerbrokers.stock.openapi.client.util.ApiLogger;
import com.tigerbrokers.stock.openapi.client.util.ProtoMessageUtil;
import com.tigerbrokers.stock.openapi.client.util.QuoteDataUtil;
import com.tigerbrokers.stock.openapi.client.util.StringUtils;
import com.tigerbrokers.stock.openapi.client.util.TradeTickUtil;
import java.util.concurrent.RejectedExecutionException;

public class ApiCallbackDecoder {
    private final ApiComposeCallback callback;
    private final MessageCallbackExecutor executor;

    public ApiCallbackDecoder(ApiComposeCallback callback) {
        this(callback, null);
    }

    public ApiCallbackDecoder(ApiComposeCallback callback, MessageCallbackExecutor executor) {
        this.callback = callback;
        this.executor = executor != null ? executor : new PerDataTypeSingleThreadExecutor();
    }

    public synchronized void handle(Response msg) {
        int code = msg.getCode();
        switch (code) {
            case 111: {
                this.processGetSubscribedSymbols(msg);
                break;
            }
            case 112: {
                this.processSubscribeEnd(msg);
                break;
            }
            case 113: {
                this.processCancelSubscribeEnd(msg);
                break;
            }
            case 200: {
                this.processErrorEnd(msg);
                break;
            }
            default: {
                this.processSubscribeDataChange(msg);
            }
        }
    }

    public ApiComposeCallback getCallback() {
        return this.callback;
    }

    private void processSubscribeDataChange(Response msg) {
        PushData pushData = msg.getBody();
        if (pushData == null || pushData.getDataType() == null) {
            return;
        }
        QuoteBasicData basicData = null;
        QuoteBBOData bboData = null;
        SocketCommon.DataType dataType = pushData.getDataType();
        switch (dataType) {
            case Quote: {
                basicData = QuoteDataUtil.convertToBasicData(pushData.getQuoteData());
                if (null != basicData) {
                    QuoteBasicData finalBasicData = basicData;
                    this.executeCallback(() -> this.callback.quoteChange(finalBasicData), dataType, finalBasicData.getSymbol());
                }
                if (null == (bboData = QuoteDataUtil.convertToAskBidData(pushData.getQuoteData()))) break;
                QuoteBBOData finalBboData = bboData;
                this.executeCallback(() -> this.callback.quoteAskBidChange(finalBboData), dataType, finalBboData.getSymbol());
                break;
            }
            case Option: {
                basicData = QuoteDataUtil.convertToBasicData(pushData.getQuoteData());
                if (null != basicData) {
                    QuoteBasicData finalBasicData = basicData;
                    this.executeCallback(() -> this.callback.optionChange(finalBasicData), dataType, finalBasicData.getSymbol());
                }
                if (null == (bboData = QuoteDataUtil.convertToAskBidData(pushData.getQuoteData()))) break;
                QuoteBBOData finalBboData = bboData;
                this.executeCallback(() -> this.callback.optionAskBidChange(finalBboData), dataType, finalBboData.getSymbol());
                break;
            }
            case Future: {
                basicData = QuoteDataUtil.convertToBasicData(pushData.getQuoteData());
                if (null != basicData) {
                    QuoteBasicData finalBasicData = basicData;
                    this.executeCallback(() -> this.callback.futureChange(finalBasicData), dataType, finalBasicData.getSymbol());
                }
                if (null == (bboData = QuoteDataUtil.convertToAskBidData(pushData.getQuoteData()))) break;
                QuoteBBOData finalBboData = bboData;
                this.executeCallback(() -> this.callback.futureAskBidChange(finalBboData), dataType, finalBboData.getSymbol());
                break;
            }
            case TradeTick: {
                if (pushData.hasTickData()) {
                    TickData tickData = pushData.getTickData();
                    this.executeCallback(() -> this.callback.fullTickChange(tickData), dataType, tickData.getSymbol());
                    break;
                }
                TradeTick tickData = TradeTickUtil.convert(pushData.getTradeTickData());
                this.executeCallback(() -> this.callback.tradeTickChange(tickData), dataType, tickData.getSymbol());
                break;
            }
            case QuoteDepth: {
                QuoteDepthData quoteDepthData = pushData.getQuoteDepthData();
                this.executeCallback(() -> this.callback.depthQuoteChange(quoteDepthData), dataType, quoteDepthData.getSymbol());
                break;
            }
            case Asset: {
                this.executeCallback(() -> this.callback.assetChange(pushData.getAssetData()), dataType, null);
                break;
            }
            case Position: {
                this.executeCallback(() -> this.callback.positionChange(pushData.getPositionData()), dataType, null);
                break;
            }
            case OrderStatus: {
                this.executeCallback(() -> this.callback.orderStatusChange(pushData.getOrderStatusData()), dataType, null);
                break;
            }
            case OrderTransaction: {
                this.executeCallback(() -> this.callback.orderTransactionChange(pushData.getOrderTransactionData()), dataType, null);
                break;
            }
            case StockTop: {
                this.executeCallback(() -> this.callback.stockTopPush(pushData.getStockTopData()), dataType, null);
                break;
            }
            case OptionTop: {
                this.executeCallback(() -> this.callback.optionTopPush(pushData.getOptionTopData()), dataType, null);
                break;
            }
            case Kline: {
                KlineData klineData = pushData.getKlineData();
                this.executeCallback(() -> this.callback.klineChange(klineData), dataType, klineData.getSymbol());
                break;
            }
            default: {
                ApiLogger.info("push data cannot be processed. {}", ProtoMessageUtil.toJson((Message)msg));
            }
        }
    }

    private void executeCallback(Runnable task, SocketCommon.DataType dataType, String symbol) {
        try {
            this.executor.execute(task, dataType, symbol);
        }
        catch (RejectedExecutionException ex) {
            ApiLogger.warn("message callback rejected, dataType:{}, symbol:{}", new Object[]{dataType, symbol, ex});
            task.run();
        }
        catch (Throwable th) {
            ApiLogger.error("message callback execution error, dataType:" + (Object)((Object)dataType) + ", symbol:" + symbol, th);
        }
    }

    private void processGetSubscribedSymbols(Response msg) {
        String subscribedSymbol = msg.getMsg();
        this.callback.getSubscribedSymbolEnd((SubscribedSymbol)JSONObject.parseObject((String)subscribedSymbol, SubscribedSymbol.class));
    }

    private void processSubscribeEnd(Response msg) {
        SocketCommon.DataType dataType = msg.getBody() == null ? null : msg.getBody().getDataType();
        this.callback.subscribeEnd(msg.getId(), dataType == null ? null : dataType.name(), msg.getMsg());
    }

    private void processCancelSubscribeEnd(Response msg) {
        SocketCommon.DataType dataType = msg.getBody() == null ? null : msg.getBody().getDataType();
        this.callback.cancelSubscribeEnd(msg.getId(), dataType == null ? null : dataType.name(), msg.getMsg());
    }

    private void processErrorEnd(Response msg) {
        if (!StringUtils.isEmpty(msg.getMsg())) {
            this.callback.error(msg.getMsg());
        } else {
            this.callback.error("unknown error");
        }
    }

    public void processHeartBeat(String content) {
        this.callback.hearBeat(content);
    }

    public void serverHeartBeatTimeOut(String channelId) {
        this.callback.serverHeartBeatTimeOut(channelId);
    }
}

