/*
 * Decompiled with CFR 0.152.
 */
package io.github.ulisse1996.jaorm.vendor.sqlserver.functions;

import io.github.ulisse1996.jaorm.Selectable;
import io.github.ulisse1996.jaorm.vendor.VendorFunctionWithParams;
import io.github.ulisse1996.jaorm.vendor.util.ArgumentsUtils;
import java.util.Arrays;
import java.util.List;

public class ConcatFunction
implements VendorFunctionWithParams<String> {
    private final List<Selectable<String>> values;

    private ConcatFunction(List<Selectable<String>> values) {
        this.values = values;
    }

    @SafeVarargs
    public static ConcatFunction concat(Selectable<String> ... selectables) {
        return new ConcatFunction(Arrays.asList(selectables));
    }

    public String apply(String alias) {
        String s = ArgumentsUtils.concatParams(this.values, (String)alias, (String)", ");
        return String.format("CONCAT(%s)", s);
    }

    public boolean isString() {
        return true;
    }

    public List<?> getParams() {
        return ArgumentsUtils.getParams(this.values);
    }
}

