/*
 * Decompiled with CFR 0.152.
 */
package io.github.ulisse1996.jaorm.vendor.sqlserver.functions;

import io.github.ulisse1996.jaorm.Selectable;
import io.github.ulisse1996.jaorm.entity.sql.DataSourceProvider;
import io.github.ulisse1996.jaorm.spi.common.Singleton;
import io.github.ulisse1996.jaorm.vendor.ServerVersion;
import io.github.ulisse1996.jaorm.vendor.VendorFunctionWithParams;
import io.github.ulisse1996.jaorm.vendor.sqlserver.functions.TrimType;
import io.github.ulisse1996.jaorm.vendor.util.ArgumentsUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;

public class TrimFunction
implements VendorFunctionWithParams<String> {
    private static final Singleton<ServerVersion> SERVER_VERSION_SINGLETON = Singleton.instance();
    private static final char SPACE = ' ';
    private final TrimType type;
    private final char character;
    private final Selectable<String> selectable;

    public static TrimFunction trim(Selectable<String> selectable) {
        return TrimFunction.trim(null, ' ', selectable);
    }

    public static TrimFunction trim(char character, Selectable<String> selectable) {
        return TrimFunction.trim(null, character, selectable);
    }

    public static TrimFunction trim(TrimType type, Selectable<String> selectable) {
        return TrimFunction.trim(type, ' ', selectable);
    }

    public static TrimFunction trim(TrimType type, char character, Selectable<String> selectable) {
        return new TrimFunction(type, character, selectable);
    }

    private TrimFunction(TrimType type, char character, Selectable<String> selectable) {
        this.type = type;
        this.character = character;
        this.selectable = selectable;
    }

    public String apply(String alias) {
        this.initServerVersion();
        if (((ServerVersion)SERVER_VERSION_SINGLETON.get()).getMajor() < 16) {
            return this.simpleTrim(alias);
        }
        String t = this.type != null ? this.type.name() : "";
        String c = this.character != ' ' ? String.format(" '%s' FROM ", Character.valueOf(this.character)) : " ' ' FROM ";
        String s = ArgumentsUtils.getColumnName(this.selectable, (String)alias);
        return String.format("TRIM(%s%s%s)", t, c, s);
    }

    private String simpleTrim(String alias) {
        String c;
        String s = ArgumentsUtils.getColumnName(this.selectable, (String)alias);
        String string = c = this.character != ' ' ? String.format(" '%s' FROM ", Character.valueOf(this.character)) : " ' ' FROM ";
        if (this.type == null || TrimType.BOTH.equals((Object)this.type)) {
            return String.format("TRIM(%s%s)", c, s);
        }
        if (this.character != ' ') {
            throw new IllegalArgumentException("Can't use custom char with LTRIM/RTRIM");
        }
        if (TrimType.LEADING.equals((Object)this.type)) {
            return String.format("LTRIM(%s)", s);
        }
        return String.format("RTRIM(%s)", s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initServerVersion() {
        Class<TrimFunction> clazz = TrimFunction.class;
        synchronized (TrimFunction.class) {
            if (!SERVER_VERSION_SINGLETON.isPresent()) {
                DataSource dataSource = DataSourceProvider.getCurrent().getDataSource();
                try (Connection connection = dataSource.getConnection();
                     PreparedStatement pr = connection.prepareStatement("SELECT SERVERPROPERTY('productversion')");
                     ResultSet rs = pr.executeQuery();){
                    rs.next();
                    SERVER_VERSION_SINGLETON.set((Object)ServerVersion.fromString((String)rs.getString(1)));
                }
                catch (SQLException ex) {
                    throw new IllegalArgumentException("Can't read server version !");
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public boolean isString() {
        return true;
    }

    public List<?> getParams() {
        return ArgumentsUtils.getParams(this.selectable);
    }
}

