/*
 * Decompiled with CFR 0.152.
 */
package io.github.uptonstallman.jsonlibjava.process.log;

import io.github.uptonstallman.jsonlibjava.process.JsonParseException;
import io.github.uptonstallman.jsonlibjava.process.log.Level;
import io.github.uptonstallman.jsonlibjava.process.log.Log;

public class ConsoleLog
implements Log {
    public static final String RESET = "\u001b[0m";
    public static final String BLACK = "\u001b[30m";
    public static final String RED = "\u001b[31m";
    public static final String GREEN = "\u001b[32m";
    public static final String YELLOW = "\u001b[33m";
    public static final String BLUE = "\u001b[34m";
    public static final String PURPLE = "\u001b[35m";
    public static final String CYAN = "\u001b[36m";
    public static final String WHITE = "\u001b[37m";
    private Level level = Level.INFO;

    public ConsoleLog() {
        String jsonlibLogLevel = System.getProperty("jsonlibLogLevel");
        if (jsonlibLogLevel != null) {
            this.level = Level.valueOf(jsonlibLogLevel);
        }
    }

    public ConsoleLog(Level overrideLevel) {
        this.level = overrideLevel;
    }

    @Override
    public void debug(String m) {
        if (this.level.equals((Object)Level.DEBUG)) {
            System.out.println("\u001b[35mDEBUG\u001b[0m " + this.getCallerInfo() + " " + m);
        }
    }

    @Override
    public void info(String m) {
        if (this.level.equals((Object)Level.DEBUG) || this.level.equals((Object)Level.INFO)) {
            System.out.println("\u001b[32mINFO\u001b[0m " + this.getCallerInfo() + " " + m);
        }
    }

    @Override
    public void warn(String m) {
        if (this.level.equals((Object)Level.DEBUG) || this.level.equals((Object)Level.INFO) || this.level.equals((Object)Level.WARN)) {
            System.out.println("\u001b[33mINFO\u001b[0m" + this.getCallerInfo() + " " + m);
        }
    }

    @Override
    public void error(String m) {
        System.err.println("\u001b[31mERROR\u001b[0m" + this.getCallerInfo() + " " + m);
    }

    @Override
    public void error(String m, Throwable t) {
        try {
            this.error(m + " " + (t == null ? "null" : JsonParseException.getStackTrace(t)));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    private String getCallerInfo() {
        return Thread.currentThread().getStackTrace()[3].getClassName() + "." + Thread.currentThread().getStackTrace()[3].getMethodName() + "(" + Thread.currentThread().getStackTrace()[3].getFileName() + ":" + Thread.currentThread().getStackTrace()[3].getLineNumber() + ")";
    }
}

